//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Lookup Cache Loaders" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Xomega.Framework;
using Xomega.Framework.Lookup;
using Xomega.Framework.Services;

namespace AdventureWorks.Services
{
    public partial class BusinessEntityAddressReadListCacheLoader : LocalLookupCacheLoader 
    {
        public BusinessEntityAddressReadListCacheLoader(IServiceProvider serviceProvider)
            : base(serviceProvider, true, "business entity address")
        {
        }

        protected virtual async Task<Output<ICollection<BusinessEntityAddress_ReadListOutput>>> ReadListAsync()
        {
            using (var s = serviceProvider.CreateScope())
            {
                object val;
                int _businessEntityId;
                if (Parameters.TryGetValue("business entity id", out val) && val != null)
                    _businessEntityId = (int)val;
                else return null;
                var svc = s.ServiceProvider.GetService<IBusinessEntityAddressService>();
                return await svc.ReadListAsync(_businessEntityId);
            }
        }

        protected override async Task LoadCacheAsync(string tableType, CacheUpdater updateCache, CancellationToken token = default)
        {
            Dictionary<string, Dictionary<string, Header>> data = new Dictionary<string, Dictionary<string, Header>>();
            var output = await ReadListAsync();
            if (output?.Messages != null)
                output.Messages.AbortIfHasErrors();
            else if (output?.Result == null) return;

            foreach (var row in output.Result)
            {
                string type = "business entity address";

                if (!data.TryGetValue(type, out Dictionary<string, Header> tbl))
                {
                    data[type] = tbl = new Dictionary<string, Header>();
                }
                string id = "" + row.AddressId;
                if (!tbl.TryGetValue(id, out Header h))
                {
                    tbl[id] = h = new Header(type, id, row.AddressType);
                }
                h.AddToAttribute("address line1", row.AddressLine1);
                h.AddToAttribute("address line2", row.AddressLine2);
                h.AddToAttribute("city", row.City);
                h.AddToAttribute("state", row.State);
                h.AddToAttribute("postal code", row.PostalCode);
                h.AddToAttribute("country", row.Country);
            }
            // if no data is returned we still need to update cache to mark it as loaded
            if (data.Count == 0) updateCache(new LookupTable(tableType, new List<Header>(), true));
            foreach (string type in data.Keys)
                updateCache(new LookupTable(type, data[type].Values, true));
        }
    }
}