//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "XomegaJS Data Objects" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

import { ISalesOrderService, SalesOrderDetail_CreateInput_Data, SalesOrderDetail_UpdateInput_Data } from 'ServiceContracts/Sales/ISalesOrderService';
import { DataObject, TextProperty, MoneyProperty, PositiveIntegerProperty, EnumIntProperty, IntegerProperty, PercentFractionProperty, ErrorList } from 'xomega';

export class SalesOrderDetailObject extends DataObject {

    // Properties
    public CarrierTrackingNumber: TextProperty;
    public LineTotal: MoneyProperty;
    public OrderQty: PositiveIntegerProperty;
    public ProductId: EnumIntProperty;
    public SalesOrderDetailId: IntegerProperty;
    public SalesOrderId: IntegerProperty;
    public SpecialOfferId: EnumIntProperty;
    public Subcategory: EnumIntProperty;
    public UnitPrice: MoneyProperty;
    public UnitPriceDiscount: PercentFractionProperty;

    // Construction and initialization
    init() {
        this.CarrierTrackingNumber = new TextProperty();
        this.CarrierTrackingNumber.Size = 25;
        this.LineTotal = new MoneyProperty();
        this.LineTotal.Required(true);
        this.LineTotal.Editable(false);
        this.OrderQty = new PositiveIntegerProperty();
        this.OrderQty.Required(true);
        this.ProductId = new EnumIntProperty();
        this.ProductId.Required(true);
        this.ProductId.EnumType = "product";
        this.SalesOrderDetailId = new IntegerProperty();
        this.SalesOrderDetailId.Required(true);
        this.SalesOrderDetailId.Editable(false);
        this.SalesOrderDetailId.IsKey = true;
        this.SalesOrderId = new IntegerProperty();
        this.SalesOrderId.Required(true);
        this.SalesOrderId.Editable(false);
        this.SpecialOfferId = new EnumIntProperty();
        this.SpecialOfferId.Required(true);
        this.SpecialOfferId.EnumType = "special offer";
        this.Subcategory = new EnumIntProperty();
        this.Subcategory.EnumType = "product subcategory";
        this.UnitPrice = new MoneyProperty();
        this.UnitPrice.Required(true);
        this.UnitPrice.Editable(false);
        this.UnitPriceDiscount = new PercentFractionProperty();
        this.UnitPriceDiscount.Required(true);
        this.UnitPriceDiscount.Editable(false);
    }

    protected doReadAsync(options?): JQueryPromise<any> {
        return $.when(
            $.ajax(this.getSalesOrder_Detail_ReadAsyncRequest(options)),
        );
    }

    protected doSaveAsync(options?): JQueryPromise<any> {
        if (this.IsNew()) return $.when(
            $.ajax(this.getSalesOrder_Detail_CreateAsyncRequest(options)),
        );
        return $.when(
            $.ajax(this.getSalesOrder_Detail_UpdateAsyncRequest(options)),
        );
    }

    protected doDeleteAsync(options?): JQueryPromise<any> {
        return $.when(
            $.ajax(this.getSalesOrder_Detail_DeleteAsyncRequest(options)),
        );
    }

    protected getSalesOrder_Detail_ReadAsyncRequest(options?): JQueryAjaxSettings {
        let obj = this;
        let _salesOrderDetailId: any = obj.SalesOrderDetailId.TransportValue();
        let req = ISalesOrderService.getDetail_ReadAsyncRequest(_salesOrderDetailId);
        req.success = (_data, _status, xhr) => {
            obj.fromJSON(_data.result || _data.Result, options);
            obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, null));
        }
        req.error = (xhr, _status, error) => obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, error));
        return req;
    }

    protected getSalesOrder_Detail_CreateAsyncRequest(options?): JQueryAjaxSettings {
        let obj = this;
        let _salesOrderId: any = obj.SalesOrderId.TransportValue();
        let _data: SalesOrderDetail_CreateInput_Data = obj.toStruct(SalesOrderDetail_CreateInput_Data, options);
        let req = ISalesOrderService.getDetail_CreateAsyncRequest(_salesOrderId, _data);
        req.success = (_data, _status, xhr) => {
            obj.fromJSON(_data.result || _data.Result, options);
            obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, null));
        }
        req.error = (xhr, _status, error) => obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, error));
        return req;
    }

    protected getSalesOrder_Detail_UpdateAsyncRequest(options?): JQueryAjaxSettings {
        let obj = this;
        let _salesOrderDetailId: any = obj.SalesOrderDetailId.TransportValue();
        let _data: SalesOrderDetail_UpdateInput_Data = obj.toStruct(SalesOrderDetail_UpdateInput_Data, options);
        let req = ISalesOrderService.getDetail_UpdateAsyncRequest(_salesOrderDetailId, _data);
        req.success = (_data, _status, xhr) => {
            obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, null));
        }
        req.error = (xhr, _status, error) => obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, error));
        return req;
    }

    protected getSalesOrder_Detail_DeleteAsyncRequest(options?): JQueryAjaxSettings {
        let obj = this;
        let _salesOrderDetailId: any = obj.SalesOrderDetailId.TransportValue();
        let req = ISalesOrderService.getDetail_DeleteAsyncRequest(_salesOrderDetailId);
        req.success = (_data, _status, xhr) => {
            obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, null));
        }
        req.error = (xhr, _status, error) => obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, error));
        return req;
    }
}
