//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "XomegaJS Data Objects" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

import { SalesOrderObject } from 'DataObjects/Sales/SalesOrderObjectCustomized';
import { ISalesOrderService } from 'ServiceContracts/Sales/ISalesOrderService';
import { DataListObject, TextProperty, MoneyProperty, PositiveIntegerProperty, EnumIntProperty, IntegerProperty, PercentFractionProperty, ErrorList } from 'xomega';

export class SalesOrderDetailList extends DataListObject {

    // Properties
    public CarrierTrackingNumber: TextProperty;
    public LineTotal: MoneyProperty;
    public OrderQty: PositiveIntegerProperty;
    public ProductId: EnumIntProperty;
    public SalesOrderDetailId: IntegerProperty;
    public SpecialOfferId: EnumIntProperty;
    public UnitPrice: MoneyProperty;
    public UnitPriceDiscount: PercentFractionProperty;

    // Construction and initialization
    init() {
        this.CarrierTrackingNumber = new TextProperty();
        this.CarrierTrackingNumber.Size = 25;
        this.CarrierTrackingNumber.Editable(false);
        this.LineTotal = new MoneyProperty();
        this.LineTotal.Required(true);
        this.LineTotal.Editable(false);
        this.OrderQty = new PositiveIntegerProperty();
        this.OrderQty.Required(true);
        this.OrderQty.Editable(false);
        this.ProductId = new EnumIntProperty();
        this.ProductId.Required(true);
        this.ProductId.EnumType = "product";
        this.ProductId.Editable(false);
        this.SalesOrderDetailId = new IntegerProperty();
        this.SalesOrderDetailId.Required(true);
        this.SalesOrderDetailId.Editable(false);
        this.SalesOrderDetailId.IsKey = true;
        this.SpecialOfferId = new EnumIntProperty();
        this.SpecialOfferId.Required(true);
        this.SpecialOfferId.EnumType = "special offer";
        this.SpecialOfferId.Editable(false);
        this.UnitPrice = new MoneyProperty();
        this.UnitPrice.Required(true);
        this.UnitPrice.Editable(false);
        this.UnitPriceDiscount = new PercentFractionProperty();
        this.UnitPriceDiscount.Required(true);
        this.UnitPriceDiscount.Editable(false);
    }

    protected doReadAsync(options?): JQueryPromise<any> {
        return $.when(
            $.ajax(this.getSalesOrder_Detail_ReadListAsyncRequest(
                !this.Parent() ? null : (this.Parent() as SalesOrderObject).SalesOrderId.TransportValue(), options)),
        );
    }

    protected getSalesOrder_Detail_ReadListAsyncRequest(_salesOrderId: any, options?): JQueryAjaxSettings {
        let obj = this;
        let req = ISalesOrderService.getDetail_ReadListAsyncRequest(_salesOrderId);
        req.success = (_data, _status, xhr) => {
            obj.fromJSON(_data.result || _data.Result, options);
            obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, null));
        }
        req.error = (xhr, _status, error) => obj.ValidationErrors.mergeWith(ErrorList.fromErrorResponse(xhr, error));
        return req;
    }
}
