//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Xomega Data Objects" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

using AdventureWorks.Services;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Xomega.Framework;
using Xomega.Framework.Properties;
using Xomega.Framework.Services;

namespace AdventureWorks.Client.Objects
{
    public partial class CustomerList : DataListObject
    {
        #region Constants

        public const string AccountNumber = "AccountNumber";
        public const string CustomerId = "CustomerId";
        public const string PersonId = "PersonId";
        public const string PersonName = "PersonName";
        public const string StoreId = "StoreId";
        public const string StoreName = "StoreName";
        public const string TerritoryId = "TerritoryId";

        #endregion

        #region Properties

        public TextProperty AccountNumberProperty { get; private set; }
        public IntegerKeyProperty CustomerIdProperty { get; private set; }
        public IntegerKeyProperty PersonIdProperty { get; private set; }
        public TextProperty PersonNameProperty { get; private set; }
        public IntegerKeyProperty StoreIdProperty { get; private set; }
        public TextProperty StoreNameProperty { get; private set; }
        public EnumIntProperty TerritoryIdProperty { get; private set; }

        #endregion

        #region Construction

        public CustomerList()
        {
        }

        public CustomerList(IServiceProvider serviceProvider) : base(serviceProvider)
        {
        }

        protected override void Initialize()
        {
            CustomerIdProperty = new IntegerKeyProperty(this, CustomerId)
            {
                Required = true,
                Editable = false,
                IsKey = true,
            };
            StoreIdProperty = new IntegerKeyProperty(this, StoreId)
            {
                Editable = false,
            };
            StoreNameProperty = new TextProperty(this, StoreName)
            {
                Editable = false,
            };
            PersonIdProperty = new IntegerKeyProperty(this, PersonId)
            {
                Editable = false,
            };
            PersonNameProperty = new TextProperty(this, PersonName)
            {
                Editable = false,
            };
            AccountNumberProperty = new TextProperty(this, AccountNumber)
            {
                Required = true,
                Size = 10,
                Editable = false,
            };
            TerritoryIdProperty = new EnumIntProperty(this, TerritoryId)
            {
                EnumType = "sales territory",
                Editable = false,
            };
        }

        #endregion

        #region CRUD Operations

        protected override async Task<ErrorList> DoReadAsync(object options, CancellationToken token = default)
        {
            var output = await Customer_ReadListAsync(options, 
                CriteriaObject?.ToDataContract<Customer_ReadListInput_Criteria>(options));
            return output.Messages;
        }

        #endregion

        #region Service Operations

        protected virtual async Task<Output<ICollection<Customer_ReadListOutput>>> Customer_ReadListAsync(object options, Customer_ReadListInput_Criteria _criteria)
        {
            using (var s = ServiceProvider.CreateScope())
            {
                var output = await s.ServiceProvider.GetService<ICustomerService>().ReadListAsync(_criteria);

                await FromDataContractAsync(output?.Result, options);
                return output;
            }
        }

        #endregion
    }
}