# 教程参考：
 - https://github.com/XiaomingX/my-simple-springboot-app

# Java安全教育实验框架 (Java Security Education Framework)

[GitHub stars
[License
[PRs Welcome

## 🚀 项目简介

一个基于SpringBoot的综合性安全教育平台，专注于帮助开发者、安全研究人员和学习者深入理解Web安全漏洞。本项目提供了35+种常见安全漏洞的实例，支持动手实践和验证。

### ✨ 特色功能

- 📚 全面的漏洞类型覆盖（35+种常见Web安全漏洞）
- 🔧 开箱即用的部署方案
- 🎯 详细的漏洞原理解释和复现步骤
- 🛠 完整的API接口文档
- 💡 丰富的学习资源和最佳实践指南

## 🔥 快速开始

### 环境要求
- JDK 17+
- Maven 3.6+
- Git

### 本地运行
```bash
git clone --depth 1 https://github.com/zgimszhd61/java-sec-code-plus
cd java-sec-code-plus
mvn install
mvn spring-boot:run
```

访问 `http://localhost:8080/hi` 确认服务是否正常运行。

## 📚 功能模块

<details>
<summary>🛡️ 支持的漏洞类型（点击展开）</summary>

- **注入类漏洞**：SQL注入、命令注入、SPEL注入等
- **认证授权漏洞**：身份认证绕过、越权访问等
- **配置安全**：错误配置、默认密码等
- **更多详见完整文档...**
</details>

## 🎯 应用场景

- 安全研发培训
- 渗透测试学习
- 安全产品测试验证
- 代码审计实践
- 安全意识教育

## 📖 详细文档

- [部署指南](docs/deployment.md)
- [漏洞列表](docs/vulnerabilities.md)
- [API文档](docs/api.md)
- [最佳实践](docs/best-practices.md)

## 🤝 贡献指南

我们欢迎所有形式的贡献，包括但不限于：

- 提交问题和建议
- 改进文档
- 提交代码修复
- 添加新功能

请查看[贡献指南](CONTRIBUTING.md)了解详情。

## 📄 开源许可

本项目采用 [MIT 许可证](LICENSE)。

## ⭐ Star历史

[Star History Chart

## 🌟 致谢

感谢所有贡献者对本项目的支持！

---

> 🔔 免责声明：本项目仅供学习和研究使用，禁止用于非法用途。使用本项目进行测试时，请确保已经获得相关授权。
