package com.legend.utils;

/**
 * @author Legend
 * @data by on 20-5-18.
 * @description
 */
public class Constants {

    public static final String MAIN_TITLE = "LiteNES Emulator";
    public static final String GLOBAL_SL_DIR = System.getProperties().getProperty("user.dir") + "/sl/";
    public static final String GLOBAL_CONFIG_FILE = GLOBAL_SL_DIR + "config.properties";

    public static final String LAST_OPEN_PATH = "last_open_path";
    public static final String LOOK_MEMORY = "Look Memory";
    public static final String DUMP = "dump";


    public static final String RESET = "reset";
    public static final String CHEAT = "cheat C";
    public static final String SPEED = "speed";
    public static final String IMAGE_QUALITY = "画质";
    public static final String QUALITY_LOW = "原始";
    public static final String QUALITY_MID = "中等";
    public static final String QUALITY_HIGH = "高等";
    public static final String FULL_SCREEN = "Full Screen  P";

    public static final String LOAD_ROM = "load rom";
    public static final String CLOSE_ROM = "close rom";
    public static final String SAVE_STATUS = "save status";
    public static final String LOAD_STATUS = "load status";
    public static final String EXIT = "exit";

    public static final String CREATE_ROOM = "create room";
    public static final String JOIN_ROOM = "join room";
    public static final String CURRENT_ROOM = "current room";
    public static final String EXIT_ROOM = "exit room";
    public static final String DISMISS_ROOM = "dismiss room";
    public static final String CONFIGURE_SERVER = "configure server";


    public static final String DEBUG = "debug";
    public static final String SPRM = "Sprite Memory";
    public static final String VRAM = "VRAM";
    public static final String PATTERN_TABLES_VIEWER = "PatternTables Viewer";
    public static final String NAME_TABLES_VIEWER = "NameTables Viewer";

    public static final String RUN = "Run";
    public static final String STEP_INTO = "Step Into";
    public static final String CLEAR_BREAK_POINTERS = "清空所有断点";
    public static final String ADD_BREAK_POINTER = "新增断点";

    public static final String FIRST_RELOAD_FLAG = "FirstReload&&";
}
