[model-router](README.md) / Exports

# model-router

## Table of contents

### Modules

- [constants](modules/constants.md)
- [controllers](modules/controllers.md)
- [controllers/generation.controller](modules/controllers_generation_controller.md)
- [controllers/healthCheck.controller](modules/controllers_healthCheck_controller.md)
- [controllers/model.controller](modules/controllers_model_controller.md)
- [controllers/modelUsage.controller](modules/controllers_modelUsage_controller.md)
- [controllers/prompt.controller](modules/controllers_prompt_controller.md)
- [controllers/provider.controller](modules/controllers_provider_controller.md)
- [controllers/user.controller](modules/controllers_user_controller.md)
- [handlers/completeHandler](modules/handlers_completeHandler.md)
- [handlers/streamHandler](modules/handlers_streamHandler.md)
- [index](modules/index.md)
- [library/customError](modules/library_customError.md)
- [models/Model](modules/models_Model.md)
- [models/ModelCost](modules/models_ModelCost.md)
- [models/ModelHealthCheck](modules/models_ModelHealthCheck.md)
- [models/ModelUsage](modules/models_ModelUsage.md)
- [models/Prompt](modules/models_Prompt.md)
- [models/Provider](modules/models_Provider.md)
- [models/User](modules/models_User.md)
- [plugins/db](modules/plugins_db.md)
- [providers/anthropic/generate](modules/providers_anthropic_generate.md)
- [providers/anthropic/healthCheck](modules/providers_anthropic_healthCheck.md)
- [providers/anthropic/tokenUsage](modules/providers_anthropic_tokenUsage.md)
- [providers/chatOpenai/generate](modules/providers_chatOpenai_generate.md)
- [providers/chatOpenai/healthCheck](modules/providers_chatOpenai_healthCheck.md)
- [providers/chatOpenai/tokenUsage](modules/providers_chatOpenai_tokenUsage.md)
- [providers/cohere/generate](modules/providers_cohere_generate.md)
- [providers/cohere/healthCheck](modules/providers_cohere_healthCheck.md)
- [providers/cohere/tokenUsage](modules/providers_cohere_tokenUsage.md)
- [providers/openai/generate](modules/providers_openai_generate.md)
- [providers/openai/healthCheck](modules/providers_openai_healthCheck.md)
- [providers/openai/tokenUsage](modules/providers_openai_tokenUsage.md)
- [routes](modules/routes.md)
- [routes/generation.route](modules/routes_generation_route.md)
- [routes/healthCheck.route](modules/routes_healthCheck_route.md)
- [routes/model.route](modules/routes_model_route.md)
- [routes/modelUsage.route](modules/routes_modelUsage_route.md)
- [routes/prompt.route](modules/routes_prompt_route.md)
- [routes/provider.route](modules/routes_provider_route.md)
- [routes/user.route](modules/routes_user_route.md)
- [schema](modules/schema.md)
- [schema/generation.schema](modules/schema_generation_schema.md)
- [schema/healthCheck.schema](modules/schema_healthCheck_schema.md)
- [schema/model.schema](modules/schema_model_schema.md)
- [schema/modelUsage.schema](modules/schema_modelUsage_schema.md)
- [schema/prompt.schema](modules/schema_prompt_schema.md)
- [schema/provider.schema](modules/schema_provider_schema.md)
- [schema/providerSchemas](modules/schema_providerSchemas.md)
- [schema/providerSchemas/anthropic.schema](modules/schema_providerSchemas_anthropic_schema.md)
- [schema/providerSchemas/chatOpenai.schema](modules/schema_providerSchemas_chatOpenai_schema.md)
- [schema/providerSchemas/cohere.schema](modules/schema_providerSchemas_cohere_schema.md)
- [schema/providerSchemas/openai.schema](modules/schema_providerSchemas_openai_schema.md)
- [schema/user.schema](modules/schema_user_schema.md)
- [scripts](modules/scripts.md)
- [scripts/initModels](modules/scripts_initModels.md)
- [scripts/initProviders](modules/scripts_initProviders.md)
- [server](modules/server.md)
- [swagger](modules/swagger.md)
- [types/prompt.interface](modules/types_prompt_interface.md)
- [utils/mapPromptParams](modules/utils_mapPromptParams.md)
- [utils/schemaValidator](modules/utils_schemaValidator.md)
- [utils/streamCompletion](modules/utils_streamCompletion.md)
- [utils/updateHealthCheck](modules/utils_updateHealthCheck.md)
