# Generated by Django 2.2.16 on 2021-05-28 04:25

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('api', '0029_auto_20210503_1040'),
    ]

    operations = [
        migrations.AlterField(
            model_name='deletedimage',
            name='identifier',
            field=models.UUIDField(help_text='The identifier of the deleted media.', primary_key=True, serialize=False, unique=True),
        ),
        migrations.AlterField(
            model_name='image',
            name='identifier',
            field=models.UUIDField(db_index=True, help_text='Our unique identifier for an open-licensed work.', unique=True),
        ),
        migrations.AlterField(
            model_name='image',
            name='provider',
            field=models.CharField(blank=True, db_index=True, help_text='The content provider, e.g. Flickr, Jamendo...', max_length=80, null=True),
        ),
        migrations.AlterField(
            model_name='image',
            name='source',
            field=models.CharField(blank=True, db_index=True, help_text='The source of the data, meaning a particular dataset. Source and provider can be different. Eg: the Google Open Images dataset is source=openimages, but provider=flickr.', max_length=80, null=True),
        ),
        migrations.AlterField(
            model_name='image',
            name='url',
            field=models.URLField(help_text='The actual URL to the media file.', max_length=1000, unique=True),
        ),
        migrations.AlterField(
            model_name='imagereport',
            name='description',
            field=models.TextField(blank=True, help_text='The explanation on why media is being reported.', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='imagereport',
            name='identifier',
            field=models.UUIDField(help_text='The ID for media to be reported.'),
        ),
        migrations.AlterField(
            model_name='imagereport',
            name='reason',
            field=models.CharField(choices=[('mature', 'mature'), ('dmca', 'dmca'), ('other', 'other')], help_text='The reason to report media to Openverse.', max_length=20),
        ),
    ]
