{-
Welcome to your new Dhall package-set!

Below are instructions for how to edit this file for most use
cases, so that you don't need to know Dhall to use it.

## Warning: Don't Move This Top-Level Comment!

Due to how `dhall format` currently works, this comment's
instructions cannot appear near corresponding sections below
because `dhall format` will delete the comment. However,
it will not delete a top-level comment like this one.

## Use Cases

Most will want to do one or both of these options:
1. Override/Patch a package's dependency
2. Add a package not already in the default package set

This file will continue to work whether you use one or both options.
Instructions for each option are explained below.

### Overriding/Patching a package

Purpose:
- Change a package's dependency to a newer/older release than the
    default package set's release
- Use your own modified version of some dependency that may
    include new API, changed API, removed API by
    using your custom git repo of the library rather than
    the package set's repo

Syntax:
Replace the overrides' "{=}" (an empty record) with the following idea
The "//" or "⫽" means "merge these two records and
  when they have the same value, use the one on the right:"
-------------------------------
let override =
  { packageName =
      upstream.packageName // { updateEntity1 = "new value", updateEntity2 = "new value" }
  , packageName =
      upstream.packageName // { version = "v4.0.0" }
  , packageName =
      upstream.packageName // { repo = "https://www.example.com/path/to/new/repo.git" }
  }
-------------------------------

Example:
-------------------------------
let overrides =
  { halogen =
      upstream.halogen // { version = "master" }
  , halogen-vdom =
      upstream.halogen-vdom // { version = "v4.0.0" }
  }
-------------------------------

### Additions

Purpose:
- Add packages that aren't already included in the default package set

Syntax:
Replace the additions' "{=}" (an empty record) with the following idea:
-------------------------------
let additions =
  { package-name =
       { dependencies =
           [ "dependency1"
           , "dependency2"
           ]
       , repo =
           "https://example.com/path/to/git/repo.git"
       , version =
           "tag ('v4.0.0') or branch ('master')"
       }
  , package-name =
       { dependencies =
           [ "dependency1"
           , "dependency2"
           ]
       , repo =
           "https://example.com/path/to/git/repo.git"
       , version =
           "tag ('v4.0.0') or branch ('master')"
       }
  , etc.
  }
-------------------------------

Example:
-------------------------------
let additions =
  { benchotron =
      { dependencies =
          [ "arrays"
          , "exists"
          , "profunctor"
          , "strings"
          , "quickcheck"
          , "lcg"
          , "transformers"
          , "foldable-traversable"
          , "exceptions"
          , "node-fs"
          , "node-buffer"
          , "node-readline"
          , "datetime"
          , "now"
          ]
      , repo =
          "https://github.com/hdgarrood/purescript-benchotron.git"
      , version =
          "v7.0.0"
      }
  }
-------------------------------
-}
let upstream =
      https://github.com/purescript/package-sets/releases/download/psc-0.14.0-20210308/packages.dhall sha256:5a86da7913f6c84adc2efacfad49ca135af8f62235e7270d9b952a8dda3c4b47

in  upstream
  with b64 = 
    { dependencies =
      [ "console", "effect", "node-fs-aff", "wai", "encoding" ]
    , repo = "https://github.com/CarstenKoenig/purescript-b64.git"
    , version = "purescript-0.14"
    }
  with warp =
    { dependencies =
      [ "console", "effect", "node-fs-aff", "wai" ]
    , repo = "https://github.com/Woody88/purescript-warp.git"
    , version = "master"
    }
  with debugged =
    { dependencies =
      [ "console"
      , "effect"
      , "prelude"
      , "strings"
      , "record"
      , "ordered-collections"
      , "either"
      , "tuples"
      , "lists"
      , "arrays"
      , "bifunctors"
      , "datetime"
      , "enums"
      ]
    , repo = "https://github.com/Woody88/purescript-debugged.git"
    , version = "ps-0.14"
    }
  with wai =
    { dependencies = [ "effect", "aff", "http-types", "node-net" ]
    , repo = "https://github.com/Woody88/purescript-wai.git"
    , version = "master"
    }
  with http-types =
    { dependencies = [ "js-uri", "tuples", "unicode" ]
    , repo = "https://github.com/Woody88/purescript-http-types.git"
    , version = "master"
    }
  with http-media =
    { dependencies =
      [ "console"
      , "effect"
      , "exceptions"
      , "foldable-traversable"
      , "maybe"
      , "newtype"
      , "numbers"
      , "ordered-collections"
      , "psci-support"
      , "strings"
      , "stringutils"
      , "unicode"
      ]
    , repo = "https://github.com/Woody88/purescript-http-media.git"
    , version = "master"
    }
