### DataList

Renders a list of elements from an array of primitives.

* Use the value of the `isOrdered` prop to conditionally render a `<ol>` or `<ul>` list.
* Use `Array.prototype.map` to render every item in `data` as a `<li>` element, give it a `key` produced from the concatenation of the its index and value.
* Omit the `isOrdered` prop to render a `<ul>` list by default.

```jsx
function DataList({ forceScrollView, data, Component }) {
  const list = data.map((val, i) => <Component key={`${i}_${val}` data={val} }></Component>);
  return forceScrollView ? <ScrollView>{list}</ScrollView> : <FlatList>{list}</FlatList>;
}
```

```jsx
const names = ['John', 'Paul', 'Mary'];
ReactDOM.render(<DataList data={names} />, document.getElementById('root'));
ReactDOM.render(<DataList data={names} isOrdered />, document.getElementById('root'));
```

<!-- tags: array -->

<!-- expertise: 0 -->
