import { PlaywrightTestConfig, devices } from '@playwright/test';

const port = 25381;

const config: PlaywrightTestConfig = {
  webServer: {
    command: `python3 -m http.server ${port}`,
    port: port,
    timeout: 1000,
    reuseExistingServer: true,
  },
  forbidOnly: !!process.env.CI,
  retries: 0,
  use: {
    trace: 'on-first-retry',
  },
  projects: [
    {
      name: 'firefox',
      use: { ...devices['Desktop Firefox'] },
    },
    {
      name: 'chromium',
      use: { ...devices['Desktop Chrome'] },
    },
  ],
};

export default config;
