# Fragment URL Spec Version 1

**Status**: Stable

## Differences from previous version

* Dot after version number is now optional.
* Multiple selections are now supported, separated by commas.
* Hash no longer needs to be specified twice when start and end hashes are the same.
* Added the ability to disambiguate multiple nodes with the same hash.

## Grammar

```
fragment  → "1", [ "." ], selection, { ",",  selection } ;
selection → sel-long | sel-short;
sel-long  → hash, ":", offset, ".", hash, ":", offset, [ dedupe ] ;
sel-short → hash, ":", offset, ":", offset, [ "~", dedupe ] ;
dedupe    → "~", { "s" | "e" }-, "~", offset, "~", offset ;
offset    → { "0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" }- ;
hash      → { "0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "A" |
              "B" | "C" | "D" | "E" | "F" | "G" | "H" | "I" | "J" | "K" | "L" |
              "M" | "N" | "O" | "P" | "Q" | "R" | "S" | "T" | "U" | "V" | "W" |
              "X" | "Y" | "Z" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" |
              "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" |
              "t" | "u" | "v" | "w" | "x" | "y" | "z" | "-" | "_" }- ;
```

## Semantics

The hash formula is [`cyrb53`](https://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript/52171480#52171480), which is just a thing some rando on stack overflow made, base64-encoded (using a non-standard alphabet). In practice, a hash can be at most nine characters, since cyrb53 is a 53-bit hash (due to silly javascript fun).

The hash is of the entire text of the text node that's selected.

The hash that comes first in the selection must be of the node that comes first in the document.

The deduplication section of the fragment is used in the case where there are multiple elements on the page with the same contents as the start or end node. It describes the full list of duplicate elements, and which ones are the correct start and end nodes. A "s" or "e" indicates a node with the same hash as the start or end node (respectively). The fist offset is the offset of the start node, and the second offset is the end node. In the case where the start and end nodes are the same, "s" must be used to describe the node (it's possible that in the future, a more condensed version of this will be used that simply uses three integers).

Multiple selections can be specified for the case of [multi-select](https://developer.mozilla.org/en-US/docs/Web/API/Selection/rangeCount).
