# Fragment URL Spec Version 0

**Status**: Stable

This is the version format that was used [before `deeplinks.js` became a library](https://github.com/WesleyAC/notebook/blob/c967f3fe6c3c0581015cf68f701fee6a43e7f678/parts/linktext.js). It's a subset of version one, so it's not explicitly included in the code — this library implements [version one](/docs/spec/v1.md), which ensures that version zero links work as well.

## Grammar

```
fragment  → "1.", hash, ":", offset, ".", hash, ":", offset ;
offset    → { "0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" }- ;
hash      → { "0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "A" |
              "B" | "C" | "D" | "E" | "F" | "G" | "H" | "I" | "J" | "K" | "L" |
              "M" | "N" | "O" | "P" | "Q" | "R" | "S" | "T" | "U" | "V" | "W" |
              "X" | "Y" | "Z" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" |
              "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" |
              "t" | "u" | "v" | "w" | "x" | "y" | "z" | "-" | "_" }- ;
```

## Semantics

The hash formula is [`cyrb53`](https://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript/52171480#52171480), which is just a thing some rando on stack overflow made, base64-encoded (using a non-standard alphabet). In practice, a hash can be at most nine characters, since cyrb53 is a 53-bit hash (due to silly javascript fun).

The hash is of the entire text of the text node that's selected.

The hash that comes first in the fragment must be of the node that comes first in the document.

This version of the link format cannot handle duplicate text nodes. This is fixed in the [next version](/docs/spec/v1.md), which is backwards compatible with this version.
