# 实践
智能合约编程需要不同的工程思维。 失败的代价可能很高，而改变可能很困难。

<br>

## 模糊测试和静态分析
模糊测试或模糊测试是一种自动化软件测试技术，涉及提供无效、意外或随机数据作为智能合约的输入。静态分析是在不执行智能合约的情况下对智能合约进行的分析。

<br>

### 智能合约模糊测试入门
[Getting Started with Smart Contract Fuzzing](https://www.immunebytes.com/blog/getting-started-with-smart-contract-fuzzing/)
### Solidity智能合约静态代码分析
[Solidity smart contract Static Code Analysis](https://lightrains.com/blogs/solidity-static-analysis-tools/#static-code-analysis)
### 智能合约模糊测试
[Smart contract Fuzzing](https://youtu.be/LRyyNzrqgOc)

<br>

## 常见威胁媒介
智能合约审计使开发人员能够提供对智能合约集的全面分析。 智能合约审计的主要目标是检测和消除漏洞，从最常见的威胁向量开始。

### 智能合约攻击向量
[Smart Contract Attack Vectors](https://github.com/kadenzipfel/smart-contract-attack-vectors)
### Solidity Security：已知攻击向量和常见反模式的综合列表
[Solidity Security: Comprehensive list of known attack vectors and common anti-patterns](https://blog.sigmaprime.io/solidity-security.html)
### 区块链攻击向量：最安全技术的漏洞
[Blockchain Attack Vectors: Vulnerabilities of the Most Secure Technology](https://www.apriorit.com/dev-blog/578-blockchain-attack-vectors)

<br>

## 随机性攻击的来源
密码系统的安全性取决于一些秘密数据，这些数据为授权人员所知，但其他人不知道且无法预测。 为了实现这种不可预测性，通常会采用一些随机化。 现代密码协议通常需要频繁生成随机数。 破坏或利用此过程中弱点的密码攻击称为随机攻击。

### 智能合约随机性或复制逻辑攻击
[Smart Contract Randomness or ReplicatedLogic Attack](https://blog.finxter.com/randomness-or-replicatedlogic-attack-on-smart-contracts/)

<br>
<br>
<br>

**访问以下链接以了解更多相关信息**<br>
以太坊智能合约安全最佳实践<br>
[Ethereum Smart Contract Security Best Practices](https://consensys.github.io/smart-contract-best-practices/)<br>
智能合约安全和审计 101<br>
[Smart Contract Security and Auditing 101](https://youtu.be/0aJfCug1zTM)
