# 什么是区块链？
区块链是在计算机网络的节点之间共享的分布式数据库或分类帐。作为数据库，区块链以电子方式以数字格式存储信息。区块链以其在比特币等加密货币系统中的关键作用而闻名，以维护安全和分散的交易记录。区块链的创新之处在于它保证了数据记录的保真度和安全性，并在不需要受信任的第三方的情况下产生信任。
<br>
典型数据库和区块链之间的一个关键区别是数据的结构。区块链以组的形式收集信息，称为块，保存信息集。块具有一定的存储容量，并且在填充时关闭并链接到先前填充的块，形成称为区块链的数据链。新添加的块之后的所有新信息都被编译成一个新形成的块，一旦填充，该块也将被添加到链中。
<br>
数据库通常将其数据结构化为表，而区块链，顾名思义，将其数据结构化为串在一起的块（块）。当以去中心化的方式实施时，这种数据结构固有地形成了不可逆转的数据时间线。当一个区块被填满时，它就会被固定下来并成为这个时间线的一部分。链中的每个块在添加到链中时都会被赋予一个准确的时间戳。
<br>
## 关键要点
- 区块链是一种共享数据库，在存储信息的方式上不同于典型的数据库；区块链将数据存储在块中，然后通过密码学将这些块链接在一起。
- 随着新数据的到来，它被输入到一个新的块中。一旦块中充满了数据，它就会链接到前一个块上，这使得数据按时间顺序链接在一起。
- 不同类型的信息可以存储在区块链上，但迄今为止最常见的用途是作为交易的分类账。
- 就比特币而言，区块链以去中心化的方式使用，因此没有任何个人或团体拥有控制权——相反，所有用户共同保留控制权。
- 分散的区块链是不可变的，这意味着输入的数据是不可逆的。对于比特币，这意味着交易会被永久记录下来并且任何人都可以查看。
<br>
<br>
# 区块链如何运作？
区块链的目标是允许记录和分发数字信息，但不能编辑。通过这种方式，区块链是不可变分类账或无法更改、删除或销毁的交易记录的基础。这就是区块链也被称为[分布式账本技术](https://www.investopedia.com/terms/d/distributed-ledger-technology-dlt.asp) (DLT) 的原因。
<br>
区块链概念于 1991 年首次作为研究项目提出，早于其首次广泛应用：比特币，于 2009 年问世。从那以后的几年里，通过创建各种加密货币、去中心化金融 (DeFi) 应用程序，区块链的使用呈爆炸式增长，不可替代代币(NFT) 和智能合约。
<br>
<br>
# 区块链去中心化
想象一下，一家公司拥有一个拥有 10,000 台计算机的服务器场，用于维护一个包含其所有客户帐户信息的数据库。 该公司拥有一座仓库大楼，所有这些计算机都集中在一个屋檐下，并且可以完全控制每台计算机及其中包含的所有信息。 然而，这提供了单点故障。如果那个地方停电了怎么办？如果它的 Internet 连接被切断怎么办？如果它烧到地上怎么办？如果一个坏角色通过一次击键删除了所有内容怎么办？在任何情况下，数据都会丢失或损坏。<br>
<br>
区块链所做的是允许该数据库中保存的数据分布在不同位置的多个网络节点之间。这不仅创造了冗余，而且还保持了存储在其中的数据的保真度——如果有人试图更改数据库的一个实例中的记录，其他节点将不会被更改，从而可以防止坏人这样做。如果一个用户篡改了比特币的交易记录，所有其他节点将相互交叉引用并轻松查明具有错误信息的节点。该系统有助于建立准确和透明的事件顺序。这样，网络中的任何单个节点都无法更改其中保存的信息。
<br>
因此，信息和历史（例如加密货币的交易）是不可逆的。这样的记录可以是交易列表（例如使用加密货币），但区块链也可以保存各种其他信息，例如法律合同、州身份证明或公司的产品库存。
            
    为了验证块的新条目或记录，大多数去中心化网络的计算能力都需要同意它。
    为了防止不良行为者验证不良交易或双花，区块链由共识机制保护，例如工作量证明(PoW) 或股权证明(PoS)。
    即使没有单个节点负责，这些机制也允许达成协议.

<br>
<br>

# 透明度
由于比特币区块链的去中心化特性，所有交易都可以通过拥有个人节点或使用允许任何人实时查看交易的区块链浏览器来透明查看。每个节点都有自己的链副本，随着新块的确认和添加而更新。这意味着如果你愿意，你可以随时随地追踪比特币。
<br>
例如，交易所过去曾被黑客入侵，那些将比特币留在交易所的人失去了一切。虽然黑客可能完全匿名，但他们提取的比特币很容易追踪。如果在其中一些黑客攻击中被盗的比特币被转移或花费在某个地方，那将是众所周知的。
<br>
当然，存储在比特币区块链（以及大多数其他区块链）中的记录是加密的。这意味着只有记录的所有者才能解密它以揭示他们的身份（使用公钥-私钥对）。因此，区块链的用户可以在保持透明度的同时保持匿名。
<br>

# 区块链安全吗？
区块链技术以多种方式实现去中心化的安全和信任。首先，新块总是按时间顺序线性存储。也就是说，它们总是被添加到区块链的“末端”。将区块添加到区块链末端后，要返回并更改区块的内容是极其困难的，除非大多数网络已达成共识。那是因为每个块都包含自己的哈希值，以及它之前的块的哈希值，以及前面提到的时间戳。哈希码是由一个数学函数创建的，该函数将数字信息转换为一串数字和字母。如果以任何方式编辑该信息，则哈希码也会更改。
<br>
假设一名黑客也在区块链网络上运行一个节点，他想要更改区块链并从其他人那里窃取加密货币。如果他们要更改自己的单一副本，它将不再与其他人的副本保持一致。当其他人相互对照他们的副本时，他们会看到这个副本脱颖而出，而黑客的链条版本将被视为非法而被抛弃。
<br>
要想成功进行此类黑客攻击，需要黑客同时控制和更改 51% 或更多的区块链副本，以便他们的新副本成为多数副本，从而成为商定的链。这样的攻击还需要大量的资金和资源，因为他们需要重做所有的块，因为它们现在有不同的时间戳和哈希码。
<br>
由于许多加密货币网络的规模及其增长速度，实现这一壮举的成本可能是无法克服的。这不仅会非常昂贵，而且可能毫无结果。做这样的事情不会被忽视，因为网络成员会看到区块链发生如此剧烈的变化。然后，网络成员将硬分叉到未受影响的链的新版本。这将导致被攻击版本的代币价值暴跌，使攻击最终变得毫无意义，因为坏人控制了无价值的资产。如果坏人要攻击比特币的新分叉，也会发生同样的情况。它是以这种方式构建的，因此参与网络比攻击网络更经济。
<br>

# 比特币与区块链
区块链技术于 1991 年由 Stuart Haber 和 W. Scott Stornetta 首次提出，这两位研究人员希望实现一个文档时间戳无法被篡改的系统。但直到将近二十年后，随着 2009 年 1 月比特币的推出，区块链才有了它的第一个现实世界应用。
<br>
比特币协议建立在区块链之上。在一篇介绍数字货币的研究论文中，比特币的匿名创造者中本聪将其称为“一种完全点对点的新型电子现金系统，没有受信任的第三方”。
<br>
这里要理解的关键是，比特币仅使用区块链作为透明记录支付分类帐的手段，但理论上，区块链可以用于不可变地记录任意数量的数据点。如上所述，这可能以交易、选举投票、产品库存、州身份证明、房屋契约等形式出现。
<br>
目前，数以万计的项目正在寻求以各种方式实施区块链，以帮助社会，而不仅仅是记录交易——例如，作为在民主选举中安全投票的一种方式。区块链不变性的性质意味着欺诈性投票将变得更加难以发生。例如，投票系统可以使一个国家的每个公民都获得一种加密货币或代币。然后，每位候选人都会获得一个特定的钱包地址，选民会将他们的代币或加密货币发送到他们希望投票给哪个候选人的地址。区块链的透明和可追溯性将消除人工计票的需要和不良行为者篡改实物选票的能力。
<br>
<br>


# 区块链与银行
区块链被誉为金融领域的颠覆性力量，尤其是在支付和银行业务方面。然而，银行和去中心化区块链有很大不同。
<br>
要了解银行与区块链有何不同，让我们将银行系统与比特币的区块链实施进行比较。
<br>
<br>
## 区块链 vs. 银行
<br>

<table>
    <tr>
        <td>特征</td>
        <td>银行</td>
        <td>区块链</td>
    </tr>
    <tr>
        <td>营业时间</td>
        <td>典型的实体银行在工作日的上午 9:00 至下午 5:00 营业。一些银行在周末营业，但营业时间有限。所有银行在银行假期都不营业。</td>
        <td>没有固定时间；一年 365 天，每天 24/7 开放。</td>
    </tr>
    <tr>
        <td>转账费</td>
        <td>•卡支付：此费用因卡而异，不由用户直接支付。 费用由商店支付给支付处理商，通常按每笔交易收取。 这种费用的影响有时会使商品和服务的成本上升。 <br>•支票：费用在 1 美元到 30 美元之间，具体取决于您的银行。 <br>•ACH：发送到外部账户时，ACH 转账费用最高可达 3 美元。<br> • 电汇：国内电汇转账费用高达 25 美元。 国际电汇转账费用高达 45 美元。</td>
        <td>比特币具有由矿工和用户确定的可变交易费用。 该费用的范围在 0 美元到 50 美元之间，但用户可以决定他们愿意支付多少费用。 这创建了一个开放的市场，如果用户将他们的费用设置得太低，他们的交易可能不会被处理。</td>
    </tr>
    <tr>
        <td>交易速度</td>
        <td>•卡支付：24-48 小时 <br>•支票：24-72 小时结清 <br>•ACH：24-48 小时 <br>•电汇：24 小时内，国际除外 <br>*周末或银行假日通常不处理银行转账</td>
        <td>比特币交易短则 15 分钟，长则一个多小时，具体取决于网络拥堵情况</td>
    </tr>
    <tr>
        <td>了解你的客户规则</td>
        <td>银行账户和其他银行产品需要“了解你的客户”(KYC) 程序。这意味着法律要求银行在开户之前记录客户的身份。</td>
        <td>任何人或任何事物都可以在没有身份的情况下参与比特币网络。 理论上，即使是配备人工智能的实体也可以参与。</td>
    </tr>
    <tr>
        <td>转移难度</td>
        <td>政府签发的身份证明、银行账户和手机是数字传输的最低要求。</td>
        <td>互联网连接和手机是最低要求。
互联网连接和手机是最低要求。</td>
    </tr>
    <tr>
        <td>隐私</td>
        <td>银行账户信息存储在银行的私人服务器上，由客户持有。银行账户隐私仅限于银行服务器的安全程度以及个人用户保护自己信息的程度。如果银行的服务器受到损害，那么个人的账户也会受到损害。</td>
        <td>比特币可以像用户希望的那样保密。所有比特币都是可追溯的，但如果是匿名购买的，则无法确定谁拥有比特币的所有权。如果比特币是在 KYC 交易所购买的，那么比特币将直接绑定到 KYC 交易所账户的持有人。</td>
    </tr>
    <tr>
        <td>安全</td>
        <td>假设客户采取可靠的互联网安全措施，例如使用安全密码和双因素身份验证，银行账户信息的安全性取决于包含客户账户信息的银行服务器。</td>
        <td>比特币网络越大，它就越安全。 比特币持有者对他们自己的比特币的安全级别完全取决于他们。 出于这个原因，建议人们对大量比特币或打算长期持有的任何数量的比特币使用冷库。</td>
    </tr>
    <tr>
        <td>批准的交易</td>
        <td>银行保留出于各种原因拒绝交易的权利。 银行也保留冻结账户的权利。 如果您的银行注意到在不寻常的地点购买或购买不寻常的物品，他们可能会被拒绝。</td>
        <td>比特币网络本身并不规定如何以任何形式或形式使用比特币。 用户可以按照自己认为合适的方式交易比特币，但也应遵守所在国家或地区的指导方针。</td>
    </tr>
    <tr>
        <td>账户没收</td>
        <td>由于 KYC 法律，政府可以出于各种原因轻松追踪人们的银行账户并扣押其中的资产。</td>
        <td>如果比特币被匿名使用，政府将很难追踪到并没收它。</td>
    </tr>
</table>


# 如何使用区块链？
正如我们现在所知，比特币区块链上的区块存储有关货币交易的数据。今天，有超过 10,000 个其他加密货币系统在区块链上运行。但事实证明，区块链实际上也是一种存储其他类型交易数据的可靠方式。
<br>

一些已经采用区块链的公司包括沃尔玛、辉瑞、AIG、西门子、联合利华等。例如，IBM 创建了其 Food Trust 区块链来追踪食品到达目的地的旅程。
<br>

为什么要这样做？食品行业已经发生了无数次大肠杆菌、沙门氏菌和李斯特菌的爆发，以及有害物质被意外引入食品中。
过去，需要数周时间才能从人们的饮食中找出这些疾病爆发的源头或致病原因。<br>

使用区块链使品牌能够跟踪食品从产地到每一站的路线，最后到交付。<br>

如果发现食物受到污染，则可以通过每个站点一直追溯到它的来源。<br>

不仅如此，这些公司现在还可以看到它可能接触过的所有其他东西，从而可以更快地发现问题并可能挽救生命。<br>

这是区块链在实践中的一个例子，但还有许多其他形式的区块链实施。
<br>

## 银行和金融
也许没有哪个行业比银行业更能从将区块链整合到其业务运营中获益。金融机构只在工作时间营业，通常是一周工作五天。这意味着，如果您试图在周五下午 6 点存入支票，您可能必须等到周一早上才能看到这笔钱打入您的账户。即使您确实在工作时间存款，由于银行需要结算的交易量巨大，交易仍可能需要一到三天的时间来验证。另一方面，区块链从不睡觉。
<br>

通过将区块链集成到银行中，消费者可以在短短 10 分钟内看到他们的交易得到处理——基本上是将区块添加到区块链所花费的时间，无论节假日或一天或一周的时间。借助区块链，银行也有机会更快、更安全地在机构之间交换资金。例如，在股票交易业务中，结算和清算过程最多可能需要三天（如果是国际交易，则可能需要更长时间），这意味着资金和股票在这段时间内会被冻结。
<br>

考虑到所涉及金额的规模，即使资金在途中只有几天时间，也会给银行带来巨大的成本和风险。
<br>
<br>

## 货币
区块链构成了比特币等加密货币的基石。美元由美联储控制。在这个中央权威系统下，用户的数据和货币在技术上是在他们的银行或政府的心血来潮。如果用户的银行遭到黑客攻击，则客户的私人信息将面临风险。如果客户的银行倒闭或客户居住在政府不稳定的国家，他们的货币价值可能会面临风险。2008 年，几家倒闭的银行获得救助——部分使用了纳税人的钱。这些是最初构思和开发比特币的担忧。
<br>

通过将其操作分散在计算机网络中，区块链允许比特币和其他加密货币在不需要中央机构的情况下运行。这不仅降低了风险，而且消除了许多处理和交易费用。它还可以为货币或金融基础设施不稳定的国家/地区的人们提供更稳定的货币、更多的应用程序以及更广泛的个人和机构网络，他们可以在国内和国际上与之开展业务。
<br>

将加密货币钱包用于储蓄账户或作为支付手段对于那些没有国家身份证明的人来说尤其意义重大。一些国家可能饱受战争蹂躏，或者其政府缺乏任何真正的基础设施来提供身份证明。这些国家的公民可能无法使用储蓄或经纪账户，因此无法安全地储存财富。
<br>


## 卫生保健
医疗保健提供者可以利用区块链安全地存储患者的医疗记录。当医疗记录生成并签名后，可以将其写入区块链，为患者提供记录不可更改的证据和信心。这些个人健康记录可以用私钥编码存储在区块链上，只有特定的个人才能访问，从而确保隐私。
<br>

## 财产记录
如果您曾经在当地的记录员办公室待过，就会知道记录产权的过程既繁琐又低效。如今，必须将实物契约交付给当地记录办公室的政府雇员，然后手动将其输入到该县的中央数据库和公共索引中。在发生财产纠纷的情况下，对财产的索赔必须与公共索引进行核对。
<br>

此过程不仅成本高昂且耗时，而且还容易出现人为错误，每一次不准确都会降低跟踪财产所有权的效率。区块链有可能消除在本地记录办公室扫描文档和追踪物理文件的需要。如果财产所有权在区块链上存储和验证，业主可以相信他们的行为是准确的并永久记录。
<br>

在饱受战争蹂躏的国家或地区，几乎没有政府或金融基础设施，当然也没有记录员办公室，几乎不可能证明财产的所有权。如果生活在这样一个地区的一群人能够利用区块链，那么就可以建立透明和明确的财产所有权时间表。
<br>


## 智能合约
智能合约是一种计算机代码，可以内置到区块链中以促进、验证或协商合同协议。智能合约在用户同意的一组条件下运行。当满足这些条件时，协议的条款将自动执行。
<br>
举例来说，潜在租户想使用智能合约租赁公寓。房东同意在租户支付保证金后立即向租户提供公寓的门禁密码。租户和房东都将交易中各自的部分发送到智能合约，智能合约将保留并在租赁开始之日自动将门禁密码交换为保证金。如果房东在租赁日期之前没有提供门禁密码，则智能合约会退还保证金。这将消除通常与使用公证人、第三方调解员或律师相关的费用和流程。
<br>

## 供应链

与 IBM Food Trust 示例一样，供应商可以使用区块链来记录他们购买的材料的来源。这将使公司不仅可以验证其产品的真实性，还可以验证“有机”、“本地”和“公平贸易”等常见标签的真实性。
<br>
正如福布斯报道的那样，食品行业越来越多地采用区块链技术来跟踪从农场到用户整个过程中食品的路径和安全性。
<br>


## 表决
如上所述，区块链可用于促进现代投票系统。正如 2018 年 11 月在西弗吉尼亚州举行的中期选举所测试的那样，使用区块链进行投票有可能消除选举舞弊并提高选民投票率。
<br>
以这种方式使用区块链将使投票几乎不可能被篡改。区块链协议还将保持选举过程的透明度，减少进行选举所需的人员，并为官员提供近乎即时的结果。这将消除重新计票的需要，也消除了对欺诈可能威胁选举的任何真正担忧。
<br>
# 区块链的优缺点
尽管区块链非常复杂，但它作为一种分散的记录保存形式的潜力几乎是无限的。<br>

从更好的用户隐私和更高的安全性到更低的处理费用和更少的错误，区块链技术很可能会看到超出上述范围的应用。<br>

但也有一些缺点。

## 优点
- 通过消除人为参与验证来提高准确性

- 通过消除第三方验证降低成本

- 权力下放使其更难被篡改

- 交易安全、私密、高效

- 透明技术

- 为政府不稳定或不发达的国家/地区的公民提供银行替代方案和保护个人信息的方法

## 缺点
- 与开采比特币相关的巨大技术成本

- 每秒交易量低

- 在非法活动中使用的历史，例如在暗网上

- 监管因司法管辖区而异且仍不确定

- 数据存储限制


# 区块链的好处

## 链条精度
区块链网络上的交易由数千台计算机组成的网络批准。这消除了验证过程中几乎所有的人为参与，从而减少了人为错误并准确记录了信息。即使网络上的一台计算机出现计算错误，错误也只会出现在区块链的一个副本上。要让该错误传播到区块链的其余部分，至少需要51% 的网络计算机出现——对于像比特币这样规模庞大且不断增长的网络来说，这几乎是不可能的。


## 降低成本
通常，消费者向银行支付费用以验证交易，向公证人支付费用以签署文件，或向牧师支付费用以执行婚姻。区块链消除了对第三方验证的需要——以及它们的相关成本。例如，企业主在接受信用卡付款时会产生少量费用，因为银行和支付处理公司必须处理这些交易。另一方面，比特币没有中央权威并且交易费用有限。

## 权力下放
区块链不会将其任何信息存储在中央位置。相反，区块链被复制并传播到计算机网络中。每当将新块添加到区块链时，网络上的每台计算机都会更新其区块链以反映更改。通过在网络中传播这些信息，而不是将其存储在一个中央数据库中，区块链变得更难以篡改。如果区块链的副本落入黑客之手，只会危及信息的单个副本，而不是整个网络。

## 高效交易
通过中央机构进行的交易最多可能需要几天时间才能结算。例如，如果您试图在周五晚上存入支票，您可能要到周一早上才能真正看到账户中的资金。金融机构通常在工作时间营业，通常是每周工作五天，而区块链每天 24 小时、每周 7 天、每年 365 天都在工作。交易可以在短短 10 分钟内完成，并且在短短几个小时后就可以被认为是安全的。这对于跨境交易特别有用，由于时区问题以及各方必须确认付款处理的事实，跨境交易通常需要更长的时间。

## 私人交易
许多区块链网络作为公共数据库运行，这意味着任何有互联网连接的人都可以查看网络交易历史列表。尽管用户可以访问有关交易的详细信息，但他们无法访问有关进行这些交易的用户的身份信息。一种常见的误解是像比特币这样的区块链网络是匿名的，而实际上它们只是保密的。
<br>
当用户进行公开交易时，他们的唯一代码（如前所述，称为公钥）会记录在区块链上。他们的个人信息不是。如果一个人在需要身份证明的交易所购买了比特币，那么这个人的身份仍然与他们的区块链地址相关联——但交易，即使与一个人的名字相关联，也不会泄露任何个人信息。
<br>

## 安全交易
一旦交易被记录下来，其真实性必须由区块链网络验证。区块链上的数千台计算机急忙确认购买细节是否正确。计算机验证交易后，将其添加到区块链块中。区块链上的每个块都包含自己唯一的哈希值，以及它之前的块的唯一哈希值。当一个区块上的信息以任何方式被编辑时，该区块的哈希码都会改变——但是，它之后的区块上的哈希码不会。这种差异使得区块链上的信息很难在没有通知的情况下被更改。

## 透明度
大多数区块链都是完全开源的软件。这意味着任何人和每个人都可以查看其代码。这使审计人员能够审查比特币等加密货币的安全性。这也意味着对于谁控制比特币代码或如何编辑它没有真正的权威。因此，任何人都可以建议对系统进行更改或升级。如果大多数网络用户都认为升级后的新版本代码是可靠且值得的，那么比特币就可以更新了。

## 为没有银行账户的人提供银行服务
也许区块链和比特币最深刻的一面是任何人，无论种族、性别或文化背景如何，都可以使用它。据世界银行称，估计有 17 亿成年人没有银行账户或任何储存金钱或财富的方式。
<br>

几乎所有这些人都生活在发展中国家，那里的经济处于起步阶段，完全依赖现金。
<br>

这些人通常会赚到一点钱，这些钱是用实物现金支付的。然后，他们需要将这些实物现金存放在家中或其他生活场所的隐蔽位置，以免遭到抢劫或不必要的暴力侵害。比特币钱包的密钥可以存储在一张纸、一部便宜的手机上，甚至可以在必要时记住。对于大多数人来说，这些选项很可能比床垫下的一小堆现金更容易隐藏。
<br>

未来的区块链也在寻找解决方案，不仅要成为财富存储的记账单位，还要存储医疗记录、产权和各种其他法律合同。

# 区块链的缺点

## 技术成本
尽管区块链可以为用户节省交易费用，但这项技术远非免费。例如，比特币网络用来验证交易的 PoW 系统消耗了大量的计算能力。在现实世界中，比特币网络上数百万台计算机的能量接近挪威和乌克兰每年消耗的能量。
<br>

尽管开采比特币的成本很高，但用户仍在继续提高电费以验证区块链上的交易。这是因为当矿工在比特币区块链中添加一个区块时，他们将获得足够的比特币作为奖励，让他们的时间和精力变得物有所值。然而，当涉及到不使用加密货币的区块链时，矿工将需要获得报酬或以其他方式被激励来验证交易。
<br>

这些问题的一些解决方案开始出现。例如，已经建立了比特币矿场，以使用太阳能、水力压裂现场多余的天然气或风力发电场的电力。
<br>

## 速度和数据效率低下
比特币是研究区块链可能效率低下的完美案例。比特币的 PoW 系统大约需要 10 分钟才能将一个新区块添加到区块链中。
<br>

按照这个速度，估计区块链网络每秒只能管理大约七笔交易 (TPS)。尽管以太坊等其他加密货币的性能优于比特币，但它们仍然受到区块链的限制。就上下文而言，传统品牌 Visa 可以处理 65,000 TPS。
<br>

这个问题的解决方案已经开发多年。目前有区块链拥有超过 30,000 TPS。
<br>

以太坊在其主网和信标链之间的合并（2022 年 9 月 15 日）预计在推出包括分片在内的升级后允许高达 100,000 TPS - 数据库的拆分以便更多设备（手机，平板电脑和笔记本电脑） ) 可以运行以太坊。这将增加网络参与度、减少拥塞并提高交易速度。
<br>

另一个问题是每个块只能容纳这么多数据。区块大小的争论一直是并将继续是区块链未来可扩展性最紧迫的问题之一。
<br>

## 非法活动
虽然区块链网络的机密性可以保护用户免受黑客攻击并保护隐私，但它也允许在区块链网络上进行非法交易和活动。被引用最多的区块链被用于非法交易的例子可能是丝绸之路，这是一个在线暗网非法毒品和洗钱市场，从 2011 年 2 月一直运营到 2013 年 10 月，之后被联邦调查局关闭。
<br>

暗网允许用户买卖非法商品而无需使用Tor 浏览器进行跟踪，并以比特币或其他加密货币进行非法购买。美国现行法规要求金融服务提供商在开户时获取有关客户的信息，核实每个客户的身份，并确认客户没有出现在任何已知或疑似恐怖组织的名单上。
<br>

该系统可以被视为既有利又不利。它让任何人都可以访问金融账户，但也让犯罪分子更容易进行交易。许多人认为，加密货币的良好用途，如为没有银行账户的世界提供银行服务，胜过加密货币的不良用途，尤其是当大多数非法活动仍通过无法追踪的现金完成时。
<br>

虽然比特币很早就被用于此类目的，但其作为金融资产的透明性和成熟度实际上已经导致非法活动转移到其他加密货币，如 Monero 和 Dash。
<br>

如今，非法活动仅占所有比特币交易的一小部分。
<br>


## 规定
加密领域的许多人都对政府对加密货币的监管表示担忧。随着去中心化网络的发展，结束像比特币这样的东西变得越来越困难，几乎不可能，但政府理论上可以将拥有加密货币或参与其网络定为非法。
<br>

随着时间的推移，这种担忧变得越来越小，因为像 PayPal 这样的大公司开始允许在其平台上拥有和使用加密货币。
<br>

# 什么是简单的区块链？
简单地说，区块链是一个共享的数据库或账本。数据片段存储在称为块的数据结构中，网络的每个节点都有整个数据库的精确副本。安全性得到保证，因为如果有人试图编辑或删除分类帐副本中的条目，大多数人不会反映此更改，并且会被拒绝。
<br>

# 有多少个区块链？
实时区块链的数量每天都在以越来越快的速度增长。截至 2022 年，有超过 10,000 种基于区块链的活跃加密货币，还有数百种非加密货币区块链。
<br>

# 私有区块链和公共区块链有什么区别？
公共区块链，也称为开放或无需许可的区块链，是任何人都可以自由加入网络并建立节点的区块链。由于其开放性，这些区块链必须通过密码学和共识系统（如工作量证明（PoW））来保护。
<br>

另一方面，私有或许可区块链要求每个节点在加入之前都经过批准。因为节点被认为是可信的，所以安全层不需要那么健壮。
<br>

# 什么是区块链平台？
区块链平台允许用户和开发人员在现有区块链基础设施之上创建新用途。一个例子是以太坊，它有一种称为以太(ETH) 的本地加密货币。
<br>

但以太坊区块链还允许创建用于初始代币发行(ICO) 和不可替代代币 (NFT) 的智能合约和可编程代币。这些都是围绕以太坊基础设施构建的，并由以太坊网络上的节点保护。
<br>

# 谁发明了区块链？
1991 年，两位数学家 Stuart Haber 和 W. Scott Stornetta 首次概述了区块链技术，他们希望实现一个文档时间戳不可篡改的系统。
<br>

在 1990 年代后期，Cypherpunk Nick Szabo提议使用区块链来保护数字支付系统，称为比特黄金（从未实施）。
<br>


# 底线
随着该技术的许多实际应用已经被实施和探索，区块链终于在很大程度上因比特币和加密货币而名声大噪。作为每个国家投资者口中的流行语，区块链旨在使企业和政府运营更加准确、高效、安全和廉价，减少中间商。
<br>

当我们准备进入区块链的第三个十年时，传统公司是否会掌握这项技术不再是问题——而是何时的问题。今天，我们看到了 NFT 的激增和资产的代币化。未来几十年将被证明是区块链的重要增长时期。
<br>
<br>
<br>
<br>
<br>

**原文链接**
<br>
https://www.investopedia.com/terms/b/blockchain.asp
<br>

**原文作者 及 更新信息**
<br>

By [ADAM HAYES](https://www.investopedia.com/contributors/53677/)<br>
Updated September 27, 2022<br>
Reviewed by [JEFREDA R. BROWN](https://www.investopedia.com/jefreda-brown-5188074)<br>
Fact checked by [SUZANNE KVILHAUG](https://www.investopedia.com/suzanne-kvilhaug-5197828)


