/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.ComparingUtils;

public class Pair<FIRST, SECOND> {
    public final FIRST first;
    public final SECOND second;
    private static final Pair EMPTY = Pair.create(null, null);

    public static <F, S> Pair<F, S> empty() {
        return EMPTY;
    }

    public Pair(FIRST first, SECOND second) {
        this.first = first;
        this.second = second;
    }

    public final FIRST getFirst() {
        return this.first;
    }

    public final SECOND getSecond() {
        return this.second;
    }

    public final boolean equals(Object o) {
        return o instanceof Pair && ComparingUtils.equal(this.first, ((Pair)o).first) && ComparingUtils.equal(this.second, ((Pair)o).second);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ">";
    }

    public static <F, S> Pair<F, S> create(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public static <T> T getFirst(Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }
}

