/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class DarculaTreeUI
extends BasicTreeUI {
    public static final String TREE_TABLE_TREE_KEY = "TreeTableTree";
    public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
    public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
    private static final Border LIST_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListBackgroundPainter");
    private static final Border LIST_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListSelectionBackgroundPainter");
    private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListFocusedSelectionBackgroundPainter");
    private boolean myOldRepaintAllRowValue;
    private boolean invertLineColor;
    private boolean myForceDontPaintLines = false;
    private final MouseListener mySelectionListener = new MouseAdapter(){
        boolean handled = false;

        @Override
        public void mousePressed(MouseEvent e) {
            this.handled = false;
            if (!this.isSelected(e)) {
                this.handled = true;
                this.handle(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.handled) {
                this.handle(e);
            }
        }

        private boolean isSelected(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            int selected = tree.getClosestRowForLocation(e.getX(), e.getY());
            int[] rows = tree.getSelectionRows();
            if (rows != null) {
                for (int row : rows) {
                    if (row != selected) continue;
                    return true;
                }
            }
            return false;
        }

        private void handle(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            if (SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger()) {
                if (DarculaTreeUI.this.isEditing(tree) && tree.getInvokesStopCellEditing() && !DarculaTreeUI.this.stopEditing(tree)) {
                    return;
                }
                TreePath pressedPath = DarculaTreeUI.this.getClosestPathForLocation(tree, e.getX(), e.getY());
                if (pressedPath != null) {
                    Rectangle bounds = DarculaTreeUI.this.getPathBounds(tree, pressedPath);
                    if (e.getY() >= bounds.y + bounds.height) {
                        return;
                    }
                    if (bounds.contains(e.getPoint()) || DarculaTreeUI.this.isLocationInExpandControl(pressedPath, e.getX(), e.getY())) {
                        return;
                    }
                    if (tree.getDragEnabled() || !DarculaTreeUI.this.startEditing(pressedPath, e)) {
                        DarculaTreeUI.this.selectPathForEvent(pressedPath, e);
                    }
                }
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTreeUI();
    }

    @Override
    public int getRightChildIndent() {
        return DarculaTreeUI.isSkinny() ? 8 : super.getRightChildIndent();
    }

    private static boolean isSkinny() {
        return true;
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(this.mySelectionListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
        c.removeMouseListener(this.mySelectionListener);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (Boolean.TRUE.equals(this.tree.getClientProperty("MacTreeUi.actionsInstalled"))) {
            return;
        }
        this.tree.putClientProperty("MacTreeUi.actionsInstalled", Boolean.TRUE);
        InputMap inputMap = this.tree.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
        inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand");
        ActionMap actionMap = this.tree.getActionMap();
        final Action expandAction = actionMap.get("expand");
        if (expandAction != null) {
            actionMap.put("expand", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selectionPath;
                    JTree tree;
                    int selectionRow;
                    Object source = e.getSource();
                    if (source instanceof JTree && (selectionRow = (tree = (JTree)source).getLeadSelectionRow()) != -1 && (selectionPath = tree.getPathForRow(selectionRow)) != null) {
                        boolean leaf = tree.getModel().isLeaf(selectionPath.getLastPathComponent());
                        int toSelect = -1;
                        int toScroll = -1;
                        if (!leaf && tree.isExpanded(selectionRow)) {
                            if (selectionRow + 1 < tree.getRowCount()) {
                                toScroll = toSelect = selectionRow + 1;
                            }
                        } else if (leaf) {
                            toScroll = selectionRow;
                        }
                        if (toSelect != -1) {
                            tree.setSelectionInterval(toSelect, toSelect);
                        }
                        if (toScroll != -1) {
                            tree.scrollRowToVisible(toScroll);
                        }
                        if (toSelect != -1 || toScroll != -1) {
                            return;
                        }
                    }
                    expandAction.actionPerformed(e);
                }
            });
        }
        actionMap.put("collapse_or_move_up", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    TreePath selectionPath = tree.getPathForRow(selectionRow);
                    if (selectionPath == null) {
                        return;
                    }
                    if (tree.getModel().isLeaf(selectionPath.getLastPathComponent()) || tree.isCollapsed(selectionRow)) {
                        TreePath parentPath = tree.getPathForRow(selectionRow).getParentPath();
                        if (parentPath != null && (parentPath.getParentPath() != null || tree.isRootVisible())) {
                            int parentRow = tree.getRowForPath(parentPath);
                            tree.scrollRowToVisible(parentRow);
                            tree.setSelectionInterval(parentRow, parentRow);
                        }
                    } else {
                        tree.collapseRow(selectionRow);
                    }
                }
            }
        });
    }

    public void setForceDontPaintLines() {
        this.myForceDontPaintLines = true;
    }

    @Override
    protected int getRowX(int row, int depth) {
        return DarculaTreeUI.isSkinny() ? 8 * depth + 8 : super.getRowX(row, depth);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    private boolean shouldPaintLines() {
        return this.myForceDontPaintLines || !"None".equals(this.tree.getClientProperty("JTree.lineStyle"));
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    @Override
    protected Color getHashColor() {
        Color c;
        if (this.invertLineColor && !DarculaTreeUI.equalsNullable(UIUtil.getTreeSelectionForeground(), UIUtil.getTreeForeground()) && (c = UIUtil.getTreeSelectionForeground()) != null) {
            return c.darker();
        }
        return super.getHashColor();
    }

    private static <T> boolean equalsNullable(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return b != null && a.equals(b);
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            Color background = this.tree.getBackground();
            if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                background = UIUtil.getDecoratedRowColor();
            }
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                if (selected) {
                    if (this.tree.hasFocus()) {
                        LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    } else {
                        LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else {
                    rowGraphics.setColor(background);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            } else if (selected) {
                Color bg = UIUtil.getTreeSelectionBackground(this.tree.hasFocus() || Boolean.TRUE.equals(this.tree.getClientProperty(TREE_TABLE_TREE_KEY)));
                rowGraphics.setColor(bg);
                rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
            }
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        } else {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        Rectangle bounds = g.getClipBounds();
        Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
        if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
            Graphics2D backgroundGraphics = (Graphics2D)g.create();
            backgroundGraphics.setClip(xOffset, bounds.y, containerWidth, bounds.height);
            LIST_BACKGROUND_PAINTER.paintBorder(this.tree, backgroundGraphics, xOffset, bounds.y, containerWidth, bounds.height);
            backgroundGraphics.dispose();
        }
        super.paint(g, c);
    }

    protected void paintSelectedRows(Graphics g, JTree tr) {
        Rectangle rect = tr.getVisibleRect();
        int firstVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y + rect.height);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            if (!tr.getSelectionModel().isRowSelected(row)) continue;
            Rectangle bounds = tr.getRowBounds(row);
            Color color = UIUtil.getTreeSelectionBackground(tr.hasFocus());
            if (color == null) continue;
            g.setColor(color);
            g.fillRect(0, bounds.y, tr.getWidth(), bounds.height);
        }
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                if (c instanceof JComponent) {
                    ((JComponent)c).setOpaque(false);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        if (!this.isLeaf(row)) {
            this.setExpandedIcon(DarculaUIUtil.getTreeNodeIcon(true, isPathSelected, this.tree.hasFocus()));
            this.setCollapsedIcon(DarculaUIUtil.getTreeNodeIcon(false, isPathSelected, this.tree.hasFocus()));
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

