/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;

public final class FileFilterExtensions
implements FileFilter {
    private String[] m_extensions;

    public FileFilterExtensions(String[] extensionsWithoutDot) throws IllegalArgumentException {
        this.verify(extensionsWithoutDot);
        this.m_extensions = extensionsWithoutDot;
    }

    private void verify(String[] extensions) throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer();
        for (int i = extensions.length - 1; i >= 0; --i) {
            String current = extensions[i];
            if (current == null) {
                msg.append("Extension at index " + i + " is null!\n");
                continue;
            }
            if (current.indexOf(46) == -1) continue;
            msg.append("Extension \"" + current + "\" contains a dot!\n");
        }
        if (msg.length() > 0) {
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public boolean accept(File pathname) {
        boolean ret = false;
        StringTokenizer tokenizer = new StringTokenizer(pathname.getAbsolutePath(), ".");
        String extension = "no.txt";
        while (tokenizer.hasMoreElements()) {
            extension = tokenizer.nextToken();
        }
        for (int i = this.m_extensions.length - 1; i >= 0; --i) {
            if (!this.m_extensions[i].equals(extension)) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

