/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import info.monitorenter.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodePageDetectorProxyTest {
    private CodepageDetectorProxy m_detector;

    @Before
    public void setUp() throws Exception {
        this.m_detector = CodepageDetectorProxy.getInstance();
        this.m_detector.add(new ParsingDetector(true));
        this.m_detector.add(JChardetFacade.getInstance());
        this.m_detector.add(ASCIIDetector.getInstance());
    }

    @After
    public void tearDown() throws Exception {
        this.m_detector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDetectCodePageInputStream() throws IOException {
        InputStream in = null;
        try {
            Assert.assertNotNull((Object)this.m_detector);
            File f = new File("testdocuments/stress/illegalHtmlTag/1111.htm");
            Assert.assertTrue((String)("Test file " + f.getAbsolutePath() + " does not exist. "), (boolean)f.exists());
            in = new BufferedInputStream(new FileInputStream(f));
            byte[] barr = new byte[50];
            in.mark(50);
            in.read(barr);
            in.reset();
            String originalStart = new String(barr);
            in.mark(100);
            Charset result = this.m_detector.detectCodepage(in, (int)f.length());
            System.out.println("Result: " + result);
            Assert.assertEquals((Object)Charset.forName("utf-8"), (Object)result);
            in.reset();
            in.read(barr);
            String afterStart = new String(barr);
            Assert.assertEquals((String)"Modification or stream position error.", (Object)originalStart, (Object)afterStart);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void testDetectCodePageUrl() throws IOException {
        Assert.assertNotNull((Object)this.m_detector);
        File f = new File("testdocuments/xml.ascc.net/test/wf/big5/text_xml/zh-big5-0.xml");
        Assert.assertTrue((String)("Test file " + f.getAbsolutePath() + " does not exist. "), (boolean)f.exists());
        URL url = f.toURL();
        Charset result = this.m_detector.detectCodepage(url);
        System.out.println("Result: " + result);
        Assert.assertEquals((Object)Charset.forName("Big5"), (Object)result);
        byte[] barr = FileUtil.readRAM(f);
        boolean deleted = f.delete();
        Assert.assertTrue((String)("Cannot delete " + f.getAbsolutePath() + " (has a lock?)"), (boolean)deleted);
        f.createNewFile();
        FileOutputStream out = new FileOutputStream(f);
        ((OutputStream)out).write(barr);
        out.flush();
        ((OutputStream)out).close();
        Assert.assertTrue((String)("File " + f.getAbsolutePath() + " seems to be locked (open InputStream) after detection."), (boolean)f.canWrite());
    }

    @Test
    public void testMark() throws IllegalArgumentException, IOException {
        Assert.assertNotNull((Object)this.m_detector);
        File f = new File("testdocuments/voiddocument/Voiderror.htm");
        Assert.assertTrue((String)("Test file " + f.getAbsolutePath() + " does not exist. "), (boolean)f.exists());
        URL url = f.toURL();
        this.m_detector.detectCodepage(url.openStream(), 200);
    }
}

