/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.AbstractCodepageDetector;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.UnknownCharset;
import info.monitorenter.cpdetector.io.UnsupportedCharset;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class ByteOrderMarkDetector
extends AbstractCodepageDetector
implements ICodepageDetector {
    public Charset detectCodepage(InputStream in, int length) throws IOException {
        Charset result = UnknownCharset.getInstance();
        int readByte = 0;
        readByte = in.read();
        switch (readByte) {
            case 0: {
                readByte = in.read();
                switch (readByte) {
                    case 0: {
                        readByte = in.read();
                        switch (readByte) {
                            case 254: {
                                try {
                                    result = Charset.forName("UCS-4BE");
                                }
                                catch (UnsupportedCharsetException uce) {
                                    result = UnsupportedCharset.forName("UCS-4BE");
                                }
                                return result;
                            }
                            case 255: {
                                try {
                                    result = Charset.forName("UCS-4");
                                }
                                catch (UnsupportedCharsetException uce) {
                                    result = UnsupportedCharset.forName("UCS-4");
                                }
                                return result;
                            }
                        }
                        return result;
                    }
                }
                return result;
            }
            case 254: {
                readByte = in.read();
                switch (readByte) {
                    case 255: {
                        readByte = in.read();
                        switch (readByte) {
                            case 0: {
                                readByte = in.read();
                                switch (readByte) {
                                    case 0: {
                                        try {
                                            result = Charset.forName("UCS-4");
                                        }
                                        catch (UnsupportedCharsetException uce) {
                                            result = UnsupportedCharset.forName("UCS-4");
                                        }
                                        return result;
                                    }
                                }
                                try {
                                    result = Charset.forName("UTF-16BE");
                                }
                                catch (UnsupportedCharsetException uce) {
                                    result = UnsupportedCharset.forName("UTF-16BE");
                                }
                                return result;
                            }
                        }
                        try {
                            result = Charset.forName("UTF-16BE");
                        }
                        catch (UnsupportedCharsetException uce) {
                            result = UnsupportedCharset.forName("UTF-16BE");
                        }
                        return result;
                    }
                }
                return result;
            }
            case 255: {
                readByte = in.read();
                switch (readByte) {
                    case 254: {
                        readByte = in.read();
                        switch (readByte) {
                            case 0: {
                                readByte = in.read();
                                switch (readByte) {
                                    case 0: {
                                        try {
                                            result = Charset.forName("UCS-4LE");
                                        }
                                        catch (UnsupportedCharsetException uce) {
                                            result = UnsupportedCharset.forName("UCS-4LE");
                                        }
                                        return result;
                                    }
                                }
                                try {
                                    result = Charset.forName("UTF-16LE");
                                }
                                catch (UnsupportedCharsetException uce) {
                                    result = UnsupportedCharset.forName("UTF-16LE");
                                }
                                return result;
                            }
                        }
                        try {
                            result = Charset.forName("UTF-16LE");
                        }
                        catch (UnsupportedCharsetException uce) {
                            result = UnsupportedCharset.forName("UTF-16LE");
                        }
                        return result;
                    }
                }
                return result;
            }
            case 239: {
                readByte = in.read();
                switch (readByte) {
                    case 187: {
                        readByte = in.read();
                        switch (readByte) {
                            case 191: {
                                try {
                                    result = Charset.forName("utf-8");
                                }
                                catch (UnsupportedCharsetException uce) {
                                    result = UnsupportedCharset.forName("utf-8");
                                }
                                return result;
                            }
                        }
                        return result;
                    }
                }
                return result;
            }
        }
        return result;
    }

    public Charset detectCodepage(URL url) throws IOException {
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        Charset result = this.detectCodepage(in, Integer.MAX_VALUE);
        in.close();
        return result;
    }
}

