/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jb2011.lnf.beautyeye.utils.LogHelper;

public class BEUtils {
    public static ImageIcon filterWithRescaleOp(ImageIcon iconBottom, float redFilter, float greenFilter, float blueFilter, float alphaFilter) {
        try {
            int w = iconBottom.getIconWidth();
            int h = iconBottom.getIconHeight();
            BufferedImage bi = new BufferedImage(w, h, 2);
            Graphics2D gg = (Graphics2D)bi.getGraphics();
            gg.drawImage(iconBottom.getImage(), 0, 0, w, h, null);
            float[] scales = new float[]{redFilter, greenFilter, blueFilter, alphaFilter};
            float[] offsets = new float[4];
            RescaleOp rop = new RescaleOp(scales, offsets, null);
            rop.filter(bi, bi);
            return new ImageIcon(bi);
        }
        catch (Exception e) {
            LogHelper.error("filterWithRescaleOp\u51fa\u9519\u4e86\uff0c" + e.getMessage() + ",iconBottom=" + iconBottom);
            return new ImageIcon();
        }
    }

    public static void draw4RecCorner(Graphics g, int x, int y, int w, int h, int \u03b2, Color c) {
        Color oldColor = g.getColor();
        g.setColor(c);
        g.drawLine(x, y, x + \u03b2, y);
        g.drawLine(x + (w - \u03b2), y, x + w, y);
        g.drawLine(x, y, x, y + \u03b2);
        g.drawLine(x, y + (h - \u03b2), x, y + h);
        g.drawLine(x, y + h, x + \u03b2, y + h);
        g.drawLine(x + (w - \u03b2), y + h, x + w, y + h);
        g.drawLine(x + w, y + h, x + w, y + (h - \u03b2));
        g.drawLine(x + w, y + \u03b2, x + w, y);
        g.setColor(oldColor);
    }

    public static void componentsOpaque(Component[] comps, boolean opaque) {
        if (comps == null) {
            return;
        }
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                if (c instanceof JComponent) {
                    ((JComponent)c).setOpaque(opaque);
                }
                BEUtils.componentsOpaque(((Container)c).getComponents(), opaque);
            } else if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(opaque);
            }
            ++n2;
        }
    }

    public static void setAntiAliasing(Graphics2D g2, boolean antiAliasing) {
        if (antiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static void fillTriangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3, Color c) {
        int[] x = new int[3];
        int[] y = new int[3];
        x[0] = x1;
        x[1] = x2;
        x[2] = x3;
        y[0] = y1;
        y[1] = y2;
        y[2] = y3;
        int n = 3;
        Polygon p = new Polygon(x, y, n);
        g.setColor(c);
        g.fillPolygon(p);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height) {
        BEUtils.drawDashedRect(g, x, y, width, height, 6, 6, 2, 2);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height, int arcWidth, int arcHeight, int separator_solid, int separator_space) {
        BEUtils.setAntiAliasing((Graphics2D)g, true);
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        BasicStroke sroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{separator_solid, separator_space}, 0.0f);
        ((Graphics2D)g).setStroke(sroke);
        g.drawRoundRect(x, y, width - 1, height - 1, arcWidth, arcHeight);
        ((Graphics2D)g).setStroke(oldStroke);
        BEUtils.setAntiAliasing((Graphics2D)g, false);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height, int step, boolean top, boolean left, boolean bottom, boolean right) {
        int drawStep = step == 0 ? 1 : 2 * step;
        int drawLingStep = step == 0 ? 1 : step;
        int vx = x;
        while (vx < x + width) {
            if (top) {
                g.fillRect(vx, y, drawLingStep, 1);
            }
            if (bottom) {
                g.fillRect(vx, y + height - 1, drawLingStep, 1);
            }
            vx += drawStep;
        }
        int vy = y;
        while (vy < y + height) {
            if (left) {
                g.fillRect(x, vy, 1, drawLingStep);
            }
            if (right) {
                g.fillRect(x + width - 1, vy, 1, drawLingStep);
            }
            vy += drawStep;
        }
    }

    public static Color getColor(Color basic, int r, int g, int b) {
        return new Color(BEUtils.getColorInt(basic.getRed() + r), BEUtils.getColorInt(basic.getGreen() + g), BEUtils.getColorInt(basic.getBlue() + b), BEUtils.getColorInt(basic.getAlpha()));
    }

    public static Color getColor(Color basic, int r, int g, int b, int a) {
        return new Color(BEUtils.getColorInt(basic.getRed() + r), BEUtils.getColorInt(basic.getGreen() + g), BEUtils.getColorInt(basic.getBlue() + b), BEUtils.getColorInt(basic.getAlpha() + a));
    }

    public static int getColorInt(int rgb) {
        return rgb < 0 ? 0 : (rgb > 255 ? 255 : rgb);
    }

    public static int getStrPixWidth(FontMetrics fm, String str) {
        return fm.stringWidth(String.valueOf(str));
    }

    public static int getStrPixWidth(Font f, String str) {
        return BEUtils.getStrPixWidth(Toolkit.getDefaultToolkit().getFontMetrics(f), str);
    }

    public static TexturePaint createTexturePaint(Image image) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return new TexturePaint(bi, new Rectangle(0, 0, imageWidth, imageHeight));
    }

    public static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void fillTextureRoundRec(Graphics2D g2, Color baseColor, int x, int y, int w, int h, int arc) {
        BEUtils.fillTextureRoundRec(g2, baseColor, x, y, w, h, arc, 35);
    }

    public static void fillTextureRoundRec(Graphics2D g2, Color baseColor, int x, int y, int w, int h, int arc, int colorDelta) {
        BEUtils.setAntiAliasing(g2, true);
        Paint oldpaint = g2.getPaint();
        GradientPaint gp = new GradientPaint(x, y, BEUtils.getColor(baseColor, colorDelta, colorDelta, colorDelta), x, y + h, baseColor);
        g2.setPaint(gp);
        g2.fillRoundRect(x, y, w, h, arc, arc);
        g2.setPaint(oldpaint);
        BEUtils.setAntiAliasing(g2, false);
    }
}

