/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch9_menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import org.jb2011.lnf.beautyeye.ch9_menu.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.ch9_menu.__IconFactory__;

public class BECheckBoxMenuItemUI
extends BasicCheckBoxMenuItemUI {
    private static boolean enforceTransparent = true;

    public static ComponentUI createUI(JComponent b) {
        return new BECheckBoxMenuItemUI();
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            __Icon9Factory__.getInstance().getBgIcon_ItemSelected().draw(g2, 0, 0, menuWidth, menuHeight);
        } else if (!enforceTransparent) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    public static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private boolean usedForVista = false;

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Image selectedImg = __IconFactory__.getInstance().getCheckboxMenuItemSelectedNormalIcon().getImage();
            boolean isSelected = model.isSelected();
            if (!isSelected) {
                selectedImg = __IconFactory__.getInstance().getCheckboxMenuItemNoneIcon().getImage();
            }
            g.drawImage(selectedImg, x + (this.usedForVista ? 5 : -4), y - 3, null);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public boolean isUsedForVista() {
            return this.usedForVista;
        }

        public CheckBoxMenuItemIcon setUsedForVista(boolean usedForVista) {
            this.usedForVista = usedForVista;
            return this;
        }
    }
}

