/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch7_popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import org.jb2011.lnf.beautyeye.ch7_popup.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.utils.WindowTranslucencyHelper;
import org.jb2011.lnf.beautyeye.widget.ImageBgPanel;

public class TranslucentPopupFactory
extends PopupFactory {
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        return new TranslucentPopup(owner, contents, x, y);
    }

    protected class TranslucentPopup
    extends Popup {
        private Component component;

        public TranslucentPopup(Component owner, Component contents, int x, int y) {
            this();
            if (contents == null) {
                throw new IllegalArgumentException("Contents must be non-null");
            }
            this.reset(owner, contents, x, y);
        }

        public TranslucentPopup() {
        }

        public void show() {
            Component component = this.getComponent();
            if (component != null) {
                component.setVisible(true);
                component.repaint();
            }
        }

        public void hide() {
            Component component = this.getComponent();
            if (component instanceof JWindow) {
                component.hide();
                ((JWindow)component).getContentPane().removeAll();
            }
            this.dispose();
        }

        protected void dispose() {
            Component component = this.getComponent();
            Window window = SwingUtilities.getWindowAncestor(component);
            if (component instanceof JWindow) {
                ((Window)component).dispose();
                component = null;
            }
            if (window instanceof DefaultFrame) {
                window.dispose();
            }
        }

        protected void reset(Component owner, Component contents, int ownerX, int ownerY) {
            Component c;
            if (this.getComponent() == null) {
                this.component = this.createComponent(owner);
            }
            if ((c = this.getComponent()) instanceof JWindow) {
                JWindow component = (JWindow)this.getComponent();
                component.setLocation(ownerX, ownerY);
                boolean isTooltip = (JComponent)contents instanceof JToolTip;
                boolean isComboBoxPopup = contents instanceof BasicComboPopup;
                WindowTranslucencyHelper.setWindowOpaque(component, false);
                WindowTranslucencyHelper.setOpacity(component, isTooltip ? 1.0f : (isComboBoxPopup ? 0.95f : 0.95f));
                ImageBgPanel imageContentPane = new ImageBgPanel().setN9(isTooltip ? __Icon9Factory__.getInstance().getTooltipBg() : (isComboBoxPopup ? org.jb2011.lnf.beautyeye.ch4_scroll.__Icon9Factory__.getInstance().getScrollPaneBorderBg() : __Icon9Factory__.getInstance().getPopupBg()));
                imageContentPane.setLayout(new BorderLayout());
                imageContentPane.add(contents, "Center");
                if (contents instanceof JComponent) {
                    ((JComponent)contents).setOpaque(false);
                    ((JComponent)contents).setDoubleBuffered(false);
                    ((JComponent)contents).setBorder(isTooltip ? BorderFactory.createEmptyBorder(6, 8, 12, 12) : (isComboBoxPopup ? BorderFactory.createEmptyBorder(6, 4, 6, 4) : BorderFactory.createEmptyBorder(5, 3, 6, 3)));
                }
                if (isComboBoxPopup) {
                    Component[] cs = ((BasicComboPopup)contents).getComponents();
                    if (cs != null && cs.length > 0) {
                        Component[] componentArray = cs;
                        int n = cs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component com = componentArray[n2];
                            if (com instanceof JScrollPane) {
                                ((JScrollPane)com).setOpaque(false);
                            }
                            ++n2;
                        }
                    }
                } else if (contents instanceof JPopupMenu) {
                    MenuElement[] mes = ((JPopupMenu)contents).getSubElements();
                    int i = 0;
                    while (i < mes.length) {
                        if (mes[i] instanceof JMenuItem) {
                            ((JMenuItem)mes[i]).setOpaque(false);
                        }
                        ++i;
                    }
                }
                component.setContentPane(imageContentPane);
                if (component.isVisible()) {
                    this.pack();
                }
            }
        }

        protected void pack() {
            Component component = this.getComponent();
            if (component instanceof Window) {
                ((Window)component).pack();
            }
        }

        protected Window getParentWindow(Component owner) {
            Window window = null;
            if (owner instanceof Window) {
                window = (Window)owner;
            } else if (owner != null) {
                window = SwingUtilities.getWindowAncestor(owner);
            }
            if (window == null) {
                window = new DefaultFrame();
            }
            return window;
        }

        protected Component createComponent(Component owner) {
            if (GraphicsEnvironment.isHeadless()) {
                return null;
            }
            return new HeavyWeightWindow(this.getParentWindow(owner));
        }

        protected Component getComponent() {
            return this.component;
        }

        protected class DefaultFrame
        extends Frame {
            protected DefaultFrame() {
            }
        }

        protected class HeavyWeightWindow
        extends JWindow {
            public HeavyWeightWindow(Window parent) {
                super(parent);
                this.setFocusableWindowState(true);
                this.setName("###overrideRedirect###");
                try {
                    this.setAlwaysOnTop(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }

            public void update(Graphics g) {
                this.paint(g);
            }

            public void show() {
                this.pack();
                super.show();
            }
        }
    }
}

