/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch5_table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import org.jb2011.lnf.beautyeye.ch5_table.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.utils.ReflectHelper;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class BETableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new BETableHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.originalHeaderRenderer = this.header.getDefaultRenderer();
        if (this.originalHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new XPDefaultRenderer());
        }
    }

    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        this.header.repaint(this.header.getHeaderRect(oldColumn));
        this.header.repaint(this.header.getHeaderRect(newColumn));
    }

    public static void paintHeadCell(Graphics g, Dimension headCellSize) {
        int w = headCellSize.width;
        int h = headCellSize.height - 1;
        __Icon9Factory__.getInstance().getTableHeaderCellBg1().draw((Graphics2D)g, 0, 0, w, h);
        __Icon9Factory__.getInstance().getTableHeaderCellSeparator1().draw((Graphics2D)g, w - 2, 0, 4, h - 1);
    }

    private static class IconBorder
    implements Border,
    UIResource {
        private final Icon icon;
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        public IconBorder(Icon icon, int top, int left, int bottom, int right) {
            this.icon = icon;
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.icon.paintIcon(c, g, x + this.left + width - this.right - this.icon.getIconWidth() - 2, y);
        }
    }

    private class XPDefaultRenderer
    extends DefaultTableCellHeaderRenderer {
        XPDefaultRenderer() {
            this.setHorizontalAlignment(10);
            this.setVerticalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Insets margins = UIManager.getInsets("TableHeader.cellMargin");
            Border border = null;
            int contentTop = 0;
            int contentLeft = 0;
            int contentBottom = 0;
            int contentRight = 0;
            if (margins != null) {
                contentTop = margins.top;
                contentLeft = margins.left;
                contentBottom = margins.bottom;
                contentRight = margins.right;
            }
            contentLeft += 5;
            contentBottom += 4;
            contentRight += 5;
            Icon sortIcon = this.getIcon();
            if (sortIcon instanceof UIResource || sortIcon == null) {
                this.setIcon(null);
                sortIcon = null;
                SortOrder sortOrder = (SortOrder)((Object)ReflectHelper.invokeMethod(DefaultTableCellHeaderRenderer.class, (Object)this, "getColumnSortOrder", new Class[]{JTable.class, Integer.TYPE}, new Object[]{table, column}));
                if (sortOrder != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                        }
                    }
                }
                if (sortIcon != null) {
                    border = new IconBorder(sortIcon, contentTop, contentLeft, contentBottom, contentRight);
                } else {
                    sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    int sortIconHeight = sortIcon != null ? sortIcon.getIconHeight() : 0;
                    border = new EmptyBorder(contentTop, contentLeft, contentBottom, contentRight);
                }
            } else {
                border = new EmptyBorder(contentTop += 3, contentLeft, contentBottom, contentRight);
            }
            this.setBorder(border);
            return this;
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            BETableHeaderUI.paintHeadCell(g, size);
            super.paint(g);
        }
    }
}

