/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.general;

import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.Serializable;

@XStreamAlias(value="Pair")
public class Pair<K, V>
implements Serializable,
Cloneable {
    @XStreamAsAttribute
    public K key;
    @XStreamAsAttribute
    public V value;

    public Pair() {
        this(null, null);
    }

    public Pair(K key) {
        this(key, null);
    }

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public int hashCode() {
        return this.key.hashCode() * 13 + (this.value == null ? 0 : this.value.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pair) {
            Pair pair = (Pair)o;
            return !(this.key == null ? pair.key != null : !this.key.equals(pair.key)) && !(this.value == null ? pair.value != null : !this.value.equals(pair.value));
        }
        return false;
    }

    public Pair<K, V> clone() {
        if (this.getKey() instanceof Cloneable && this.getValue() instanceof Cloneable) {
            return new Pair<Cloneable, Cloneable>(ReflectUtils.cloneSafely((Cloneable)this.getKey()), ReflectUtils.cloneSafely((Cloneable)this.getValue()));
        }
        throw new RuntimeException("Both key and value should implement Cloneable!");
    }
}

