/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.painter.NinePatchIconPainter;
import com.alee.extended.painter.NinePatchStatePainter;
import com.alee.global.StyleConstants;
import com.alee.graphics.filters.ShadowFilter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NinePatchUtils {
    private static final String OUTER_SHADE_PREFIX = "outer";
    private static final String INNER_SHADE_PREFIX = "inner";
    private static final String SEPARATOR = ";";
    private static final Map<String, WeakReference<NinePatchIcon>> shadeIconCache = new HashMap<String, WeakReference<NinePatchIcon>>();

    public static NinePatchIcon getShadeIcon(int shadeWidth, int round, float shadeOpacity) {
        String key = "outer;" + shadeWidth + SEPARATOR + round + SEPARATOR + shadeOpacity;
        NinePatchIcon icon = NinePatchUtils.getNinePatchIconFromCache(key);
        if (icon != null) {
            return icon;
        }
        NinePatchIcon ninePatchIcon = NinePatchUtils.createShadeIcon(shadeWidth, round, shadeOpacity);
        shadeIconCache.put(key, new WeakReference<NinePatchIcon>(ninePatchIcon));
        return ninePatchIcon;
    }

    public static NinePatchIcon createShadeIcon(int shadeWidth, int round, float shadeOpacity) {
        int inner = Math.max(shadeWidth, round) / 2;
        int width = shadeWidth * 2 + inner * 2;
        BufferedImage bi = new BufferedImage(width, width, 2);
        Graphics2D ig = bi.createGraphics();
        GraphicsUtils.setupAntialias(ig);
        ig.setPaint(Color.BLACK);
        ig.fillRoundRect(shadeWidth, shadeWidth, width - shadeWidth * 2, width - shadeWidth * 2, round * 2, round * 2);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter(shadeWidth, 0, 0, shadeOpacity);
        BufferedImage shade = sf.filter(bi, null);
        Graphics2D g2d = shade.createGraphics();
        GraphicsUtils.setupAntialias(g2d);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.setPaint(StyleConstants.transparent);
        g2d.fillRoundRect(shadeWidth, shadeWidth, width - shadeWidth * 2, width - shadeWidth * 2, round * 2, round * 2);
        g2d.dispose();
        NinePatchIcon ninePatchIcon = NinePatchIcon.create(shade);
        ninePatchIcon.addHorizontalStretch(0, shadeWidth + inner, true);
        ninePatchIcon.addHorizontalStretch(shadeWidth + inner + 1, width - shadeWidth - inner - 1, false);
        ninePatchIcon.addHorizontalStretch(width - shadeWidth - inner, width, true);
        ninePatchIcon.addVerticalStretch(0, shadeWidth + inner, true);
        ninePatchIcon.addVerticalStretch(shadeWidth + inner + 1, width - shadeWidth - inner - 1, false);
        ninePatchIcon.addVerticalStretch(width - shadeWidth - inner, width, true);
        ninePatchIcon.setMargin(shadeWidth);
        return ninePatchIcon;
    }

    public static NinePatchIcon getInnerShadeIcon(int shadeWidth, int round, float shadeOpacity) {
        String key = "inner;" + shadeWidth + SEPARATOR + round + SEPARATOR + shadeOpacity;
        NinePatchIcon icon = NinePatchUtils.getNinePatchIconFromCache(key);
        if (icon != null) {
            return icon;
        }
        NinePatchIcon ninePatchIcon = NinePatchUtils.createInnerShadeIcon(shadeWidth, round, shadeOpacity);
        shadeIconCache.put(key, new WeakReference<NinePatchIcon>(ninePatchIcon));
        return ninePatchIcon;
    }

    private static NinePatchIcon getNinePatchIconFromCache(String key) {
        return shadeIconCache.containsKey(key) ? (NinePatchIcon)shadeIconCache.get(key).get() : null;
    }

    public static NinePatchIcon createInnerShadeIcon(int shadeWidth, int round, float shadeOpacity) {
        int inner = Math.max(shadeWidth, round);
        int width = shadeWidth * 2 + inner * 2;
        BufferedImage bi = new BufferedImage(width, width, 2);
        Graphics2D ig = bi.createGraphics();
        GraphicsUtils.setupAntialias(ig);
        Area area = new Area(new Rectangle(0, 0, width, width));
        area.exclusiveOr(new Area(new RoundRectangle2D.Double(shadeWidth, shadeWidth, width - shadeWidth * 2, width - shadeWidth * 2, round * 2, round * 2)));
        ig.setPaint(Color.BLACK);
        ig.fill(area);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter(shadeWidth, 0, 0, shadeOpacity);
        BufferedImage shade = sf.filter(bi, null);
        Graphics2D g2d = shade.createGraphics();
        GraphicsUtils.setupAntialias(g2d);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.setPaint(StyleConstants.transparent);
        g2d.fill(area);
        g2d.dispose();
        BufferedImage croppedShade = shade.getSubimage(shadeWidth, shadeWidth, width - shadeWidth * 2, width - shadeWidth * 2);
        width = croppedShade.getWidth();
        NinePatchIcon ninePatchIcon = NinePatchIcon.create(croppedShade);
        ninePatchIcon.addHorizontalStretch(0, inner, true);
        ninePatchIcon.addHorizontalStretch(inner + 1, width - inner - 1, false);
        ninePatchIcon.addHorizontalStretch(width - inner, width, true);
        ninePatchIcon.addVerticalStretch(0, inner, true);
        ninePatchIcon.addVerticalStretch(inner + 1, width - inner - 1, false);
        ninePatchIcon.addVerticalStretch(width - inner, width, true);
        ninePatchIcon.setMargin(shadeWidth);
        return ninePatchIcon;
    }

    public static List<NinePatchInterval> parseIntervals(BufferedImage image, NinePatchIntervalType intervalType) {
        boolean hv = intervalType.equals((Object)NinePatchIntervalType.horizontalStretch) || intervalType.equals((Object)NinePatchIntervalType.verticalStretch);
        int l = (intervalType.equals((Object)NinePatchIntervalType.horizontalStretch) || intervalType.equals((Object)NinePatchIntervalType.horizontalContent) ? image.getWidth() : image.getHeight()) - 1;
        ArrayList<NinePatchInterval> intervals = new ArrayList<NinePatchInterval>();
        NinePatchInterval interval = null;
        for (int i = 1; i < l; ++i) {
            boolean pixelPart;
            int rgb;
            switch (intervalType) {
                case horizontalStretch: {
                    rgb = image.getRGB(i, 0);
                    break;
                }
                case verticalStretch: {
                    rgb = image.getRGB(0, i);
                    break;
                }
                case horizontalContent: {
                    rgb = image.getRGB(i, image.getHeight() - 1);
                    break;
                }
                case verticalContent: {
                    rgb = image.getRGB(image.getWidth() - 1, i);
                    break;
                }
                default: {
                    rgb = 0;
                }
            }
            boolean bl = pixelPart = rgb != Color.BLACK.getRGB();
            if (interval == null) {
                interval = new NinePatchInterval(i - 1, i - 1, pixelPart);
                continue;
            }
            if (pixelPart == interval.isPixel()) {
                interval.setEnd(i - 1);
                continue;
            }
            if (pixelPart == interval.isPixel()) continue;
            if (hv || !interval.isPixel()) {
                intervals.add(interval);
            }
            interval = new NinePatchInterval(i - 1, i - 1, pixelPart);
        }
        if (interval != null && (hv || !interval.isPixel())) {
            intervals.add(interval);
        }
        return intervals;
    }

    public static List<NinePatchInterval> parseStretchIntervals(boolean[] filled) {
        ArrayList<NinePatchInterval> intervals = new ArrayList<NinePatchInterval>();
        NinePatchInterval interval = null;
        for (int i = 0; i < filled.length; ++i) {
            boolean pixelPart;
            boolean bl = pixelPart = !filled[i];
            if (interval == null) {
                interval = new NinePatchInterval(i, i, pixelPart);
                continue;
            }
            if (pixelPart == interval.isPixel()) {
                interval.setEnd(i);
                continue;
            }
            if (pixelPart == interval.isPixel()) continue;
            intervals.add(interval);
            interval = new NinePatchInterval(i, i, pixelPart);
        }
        if (interval != null) {
            intervals.add(interval);
        }
        return intervals;
    }

    public static NinePatchIcon rotateIcon90CW(NinePatchIcon icon) {
        BufferedImage rawImage = ImageUtils.rotateImage90CW(icon.getRawImage());
        NinePatchIcon rotated = NinePatchIcon.create(rawImage);
        rotated.setHorizontalStretch(CollectionUtils.copy(icon.getVerticalStretch()));
        rotated.setVerticalStretch(CollectionUtils.copy(icon.getHorizontalStretch()));
        Insets om = icon.getMargin();
        rotated.setMargin(om.left, om.bottom, om.right, om.top);
        return rotated;
    }

    public static NinePatchIcon rotateIcon90CCW(NinePatchIcon icon) {
        BufferedImage rawImage = ImageUtils.rotateImage90CCW(icon.getRawImage());
        NinePatchIcon rotated = NinePatchIcon.create(rawImage);
        rotated.setHorizontalStretch(CollectionUtils.copy(icon.getVerticalStretch()));
        rotated.setVerticalStretch(CollectionUtils.copy(icon.getHorizontalStretch()));
        Insets om = icon.getMargin();
        rotated.setMargin(om.right, om.top, om.left, om.bottom);
        return rotated;
    }

    public static NinePatchIcon rotateIcon180(NinePatchIcon icon) {
        BufferedImage rawImage = ImageUtils.rotateImage180(icon.getRawImage());
        NinePatchIcon rotated = NinePatchIcon.create(rawImage);
        rotated.setHorizontalStretch(CollectionUtils.copy(icon.getHorizontalStretch()));
        rotated.setVerticalStretch(CollectionUtils.copy(icon.getVerticalStretch()));
        Insets om = icon.getMargin();
        rotated.setMargin(om.bottom, om.right, om.top, om.left);
        return rotated;
    }

    public static NinePatchIcon loadNinePatchIcon(Object source) {
        return NinePatchUtils.loadNinePatchIcon(XmlUtils.loadResourceFile(source));
    }

    public static NinePatchIcon loadNinePatchIcon(ResourceFile resource) {
        return new NinePatchIcon(XmlUtils.loadImageIcon(resource));
    }

    public static NinePatchStatePainter loadNinePatchStatePainter(Object source) {
        return NinePatchUtils.loadNinePatchStatePainter(XmlUtils.loadResourceMap(source));
    }

    public static NinePatchStatePainter loadNinePatchStatePainter(ResourceMap resourceMap) {
        NinePatchStatePainter sbp = new NinePatchStatePainter();
        for (String key : resourceMap.getStates().keySet()) {
            sbp.addStateIcon(key, NinePatchUtils.loadNinePatchIcon(resourceMap.getState(key)));
        }
        return sbp;
    }

    public static NinePatchIconPainter loadNinePatchIconPainter(Object source) {
        return NinePatchUtils.loadNinePatchIconPainter(XmlUtils.loadResourceFile(source));
    }

    public static NinePatchIconPainter loadNinePatchIconPainter(ResourceFile resource) {
        return new NinePatchIconPainter(NinePatchUtils.loadNinePatchIcon(resource));
    }
}

