/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JTextComponentSettingsProcessor
extends SettingsProcessor<JTextComponent, String> {
    private ActionListener actionListener;
    private FocusAdapter focusAdapter;

    public JTextComponentSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    public String getDefaultValue() {
        String defaultValue = (String)super.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        return defaultValue;
    }

    @Override
    protected void doInit(JTextComponent textComponent) {
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextComponentSettingsProcessor.this.save();
            }
        };
        textComponent.addFocusListener(this.focusAdapter);
        if (textComponent instanceof JTextField) {
            JTextField textField = (JTextField)textComponent;
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextComponentSettingsProcessor.this.save();
                }
            };
            textField.addActionListener(this.actionListener);
        }
    }

    @Override
    protected void doLoad(JTextComponent textComponent) {
        textComponent.setText((String)this.loadValue());
    }

    @Override
    protected void doSave(JTextComponent textComponent) {
        this.saveValue(textComponent.getText());
    }

    @Override
    protected void doDestroy(JTextComponent textComponent) {
        textComponent.removeFocusListener(this.focusAdapter);
        this.focusAdapter = null;
        if (textComponent instanceof JTextField) {
            JTextField textField = (JTextField)textComponent;
            textField.removeActionListener(this.actionListener);
            this.actionListener = null;
        }
    }
}

