/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.plugin.data;

import com.alee.managers.plugin.Plugin;
import com.alee.managers.plugin.data.PluginVersion;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;

@XStreamAlias(value="PluginDependency")
public class PluginDependency
implements Serializable {
    private String pluginId;
    private PluginVersion minVersion;
    private PluginVersion maxVersion;
    private Boolean optional;

    public PluginDependency() {
        this.pluginId = null;
        this.minVersion = null;
        this.maxVersion = null;
        this.optional = null;
    }

    public PluginDependency(String pluginId) {
        this.pluginId = pluginId;
        this.minVersion = null;
        this.maxVersion = null;
        this.optional = null;
    }

    public PluginDependency(String pluginId, PluginVersion minVersion) {
        this.pluginId = pluginId;
        this.minVersion = minVersion;
        this.maxVersion = null;
        this.optional = null;
    }

    public PluginDependency(String pluginId, PluginVersion minVersion, PluginVersion maxVersion) {
        this.pluginId = pluginId;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.optional = null;
    }

    public PluginDependency(String pluginId, PluginVersion minVersion, PluginVersion maxVersion, Boolean optional) {
        this.pluginId = pluginId;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.optional = optional;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public PluginVersion getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(PluginVersion minVersion) {
        this.minVersion = minVersion;
    }

    public PluginVersion getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(PluginVersion maxVersion) {
        this.maxVersion = maxVersion;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean accept(Plugin plugin) {
        if (plugin != null && plugin.getId().equals(this.pluginId)) {
            PluginVersion pv = plugin.getVersion();
            return !(this.minVersion != null && !pv.isNewerOrSame(this.minVersion) || this.maxVersion != null && !pv.isOlderOrSame(this.maxVersion));
        }
        return false;
    }

    public String toString() {
        return this.pluginId + (this.minVersion != null || this.maxVersion != null ? " " : "") + this.getVersionString("min", this.minVersion) + (this.minVersion != null ? " " : "") + this.getVersionString("max", this.maxVersion);
    }

    public String getVersionString(String prefix, PluginVersion pluginVersion) {
        return pluginVersion != null ? "[ " + prefix + ": " + pluginVersion + " ]" : "";
    }
}

