/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.KeyStroke;

@XStreamAlias(value="HotkeyData")
public class HotkeyData
implements Serializable,
Cloneable {
    @XStreamAsAttribute
    protected boolean isCtrl;
    @XStreamAsAttribute
    protected boolean isAlt;
    @XStreamAsAttribute
    protected boolean isShift;
    @XStreamAsAttribute
    protected Integer keyCode;
    protected transient Integer hashCode;

    public HotkeyData() {
        this.isCtrl = false;
        this.isAlt = false;
        this.isShift = false;
        this.keyCode = null;
        this.hashCode = null;
    }

    public HotkeyData(KeyEvent keyEvent) {
        this.isCtrl = SwingUtils.isCtrl(keyEvent);
        this.isAlt = SwingUtils.isAlt(keyEvent);
        this.isShift = SwingUtils.isShift(keyEvent);
        this.keyCode = keyEvent.getKeyCode();
        this.hashCode = null;
    }

    public HotkeyData(Integer keyCode) {
        this.isCtrl = false;
        this.isAlt = false;
        this.isShift = false;
        this.keyCode = keyCode;
        this.hashCode = null;
    }

    public HotkeyData(boolean isCtrl, boolean isAlt, boolean isShift, Integer keyCode) {
        this.isCtrl = isCtrl;
        this.isAlt = isAlt;
        this.isShift = isShift;
        this.keyCode = keyCode;
        this.hashCode = null;
    }

    public HotkeyData(KeyStroke keyStroke) {
        this.setModifiers(keyStroke.getModifiers());
        this.keyCode = keyStroke.getKeyCode();
        this.hashCode = null;
    }

    public boolean isCtrl() {
        return this.isCtrl;
    }

    public void setCtrl(boolean ctrl) {
        this.isCtrl = ctrl;
        this.hashCode = null;
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public void setAlt(boolean alt) {
        this.isAlt = alt;
        this.hashCode = null;
    }

    public boolean isShift() {
        return this.isShift;
    }

    public void setShift(boolean shift) {
        this.isShift = shift;
        this.hashCode = null;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(Integer keyCode) {
        this.keyCode = keyCode;
        this.hashCode = null;
    }

    public boolean isHotkeySet() {
        return this.keyCode != null;
    }

    public boolean isTriggered(KeyEvent event) {
        return this.areControlsTriggered(event) && this.isKeyTriggered(event);
    }

    public boolean areControlsTriggered(KeyEvent event) {
        return SwingUtils.isShortcut(event) == this.isCtrl && SwingUtils.isAlt(event) == this.isAlt && SwingUtils.isShift(event) == this.isShift;
    }

    public boolean isKeyTriggered(KeyEvent event) {
        return event.getKeyCode() == this.keyCode.intValue();
    }

    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(this.keyCode, this.getModifiers());
    }

    public int getModifiers() {
        return (this.isCtrl ? SwingUtils.getSystemShortcutModifier() : 0) | (this.isAlt ? 8 : 0) | (this.isShift ? 1 : 0);
    }

    public void setModifiers(int modifiers) {
        this.isCtrl = SwingUtils.isCtrl(modifiers);
        this.isAlt = SwingUtils.isAlt(modifiers);
        this.isShift = SwingUtils.isShift(modifiers);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof HotkeyData && obj.hashCode() == this.hashCode();
    }

    public String toString() {
        return SwingUtils.hotkeyToString(this);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    protected HotkeyData clone() {
        return new HotkeyData(this.isCtrl(), this.isAlt(), this.isShift(), this.getKeyCode());
    }
}

