/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.focus;

import com.alee.managers.focus.FocusTracker;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DefaultFocusTracker
implements FocusTracker {
    private boolean enabled = true;
    private boolean uniteWithChilds;
    private List<WeakReference<Component>> customChildren;

    public DefaultFocusTracker() {
        this(true);
    }

    public DefaultFocusTracker(boolean uniteWithChilds) {
        this.uniteWithChilds = uniteWithChilds;
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.enabled;
    }

    public void setTrackingEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isInvolved(Component component, Component tracked) {
        block8: {
            block7: {
                if (!this.isUniteWithChilds()) break block7;
                if (SwingUtils.isEqualOrChild(tracked, component)) {
                    return true;
                }
                if (this.customChildren == null) break block8;
                Iterator<WeakReference<Component>> iterator = this.customChildren.iterator();
                while (iterator.hasNext()) {
                    WeakReference<Component> next = iterator.next();
                    Component customChild = (Component)next.get();
                    if (customChild == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!SwingUtils.isEqualOrChild(customChild, component)) continue;
                    return true;
                }
                break block8;
            }
            if (tracked == component) {
                return true;
            }
            if (this.customChildren != null) {
                Iterator<WeakReference<Component>> iterator = this.customChildren.iterator();
                while (iterator.hasNext()) {
                    WeakReference<Component> next = iterator.next();
                    Component customChild = (Component)next.get();
                    if (customChild == null) {
                        iterator.remove();
                        continue;
                    }
                    if (customChild != component) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isUniteWithChilds() {
        return this.uniteWithChilds;
    }

    public void setUniteWithChilds(boolean uniteWithChilds) {
        this.uniteWithChilds = uniteWithChilds;
    }

    public List<Component> getCustomChildren() {
        ArrayList<Component> children = new ArrayList<Component>(this.customChildren.size());
        Iterator<WeakReference<Component>> iterator = this.customChildren.iterator();
        while (iterator.hasNext()) {
            WeakReference<Component> next = iterator.next();
            Component component = (Component)next.get();
            if (component == null) {
                iterator.remove();
                continue;
            }
            children.add(component);
        }
        return children;
    }

    public List<WeakReference<Component>> getWeakCustomChildren() {
        return this.customChildren;
    }

    public void setCustomChildren(List<Component> customChildren) {
        for (Component customChild : customChildren) {
            this.addCustomChild(customChild);
        }
    }

    public void addCustomChild(Component customChild) {
        if (this.customChildren == null) {
            this.customChildren = new ArrayList<WeakReference<Component>>(1);
        }
        this.customChildren.add(new WeakReference<Component>(customChild));
    }

    public void removeCustomChild(Component customChild) {
        if (this.customChildren != null) {
            Iterator<WeakReference<Component>> iterator = this.customChildren.iterator();
            while (iterator.hasNext()) {
                WeakReference<Component> next = iterator.next();
                Component component = (Component)next.get();
                if (component != null && component != customChild) continue;
                iterator.remove();
            }
        }
    }
}

