/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.effects;

import com.alee.extended.window.TestFrame;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class EffectsManager {
    public static void fadeOut(JComponent component) {
        final BufferedImage bi = SwingUtils.createComponentSnapshot(component);
        final Rectangle b = SwingUtils.getBoundsInWindow(component);
        final WebGlassPane wgp = GlassPaneManager.getGlassPane(component);
        wgp.setPaintedImage(bi, b.getLocation(), 100);
        component.setVisible(false);
        WebTimer.repeat("EffectsManager.fadeOut", StyleConstants.avgAnimationDelay, new ActionListener(){
            private int opacity = 100;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.opacity > 0) {
                    this.opacity -= 5;
                    Point l = b.getLocation();
                    l.y += (100 - this.opacity) / 2;
                    wgp.setPaintedImage(bi, l, this.opacity);
                } else {
                    wgp.clearPaintedImage();
                    ((WebTimer)e.getSource()).stop();
                }
            }
        });
    }

    public static void main(String[] args) {
        WebLookAndFeel.install();
        final WebButton b1 = new WebButton("1");
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffectsManager.fadeOut(b1);
            }
        });
        final WebButton b2 = new WebButton("2");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffectsManager.fadeOut(b2);
            }
        });
        final WebButton b3 = new WebButton("3");
        b3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffectsManager.fadeOut(b3);
            }
        });
        new TestFrame((Component)new WebToolBar(){
            {
                this.setFloatable(false);
                this.add((Component)b1);
                this.add((Component)b2);
                this.add((Component)b3);
            }
        }, 50);
    }
}

