/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebTreeModel<E extends DefaultMutableTreeNode>
extends DefaultTreeModel {
    public WebTreeModel(E root) {
        super((TreeNode)root);
    }

    public WebTreeModel(E root, boolean asksAllowsChildren) {
        super((TreeNode)root, asksAllowsChildren);
    }

    public E getRootNode() {
        return (E)((DefaultMutableTreeNode)this.getRoot());
    }

    public void insertNodesInto(List<E> children, E parent, int index) {
        for (int i = children.size() - 1; i >= 0; --i) {
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)children.get(i), index);
        }
        int[] indices = new int[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
    }

    public void insertNodesInto(E[] children, E parent, int index) {
        for (int i = children.length - 1; i >= 0; --i) {
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)children[i], index);
        }
        int[] indices = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
    }

    public void removeNodesFromParent(List<E> nodes) {
        for (DefaultMutableTreeNode node : nodes) {
            this.removeNodeFromParent(node);
        }
    }

    public void removeNodesFromParent(E node) {
        for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
            this.removeNodeFromParent((MutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i));
        }
    }

    public void removeNodesFromParent(E[] nodes) {
        for (E node : nodes) {
            this.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        MutableTreeNode aNode = (MutableTreeNode)path.getLastPathComponent();
        this.nodeChanged(aNode);
    }

    public void updateNode(E node) {
        if (node != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)node), null, null);
        }
    }

    public void updateNodeStructure(E node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot((TreeNode)node), null, null);
        }
    }

    public void updateTree() {
        this.fireTreeStructureChanged(this, ((DefaultMutableTreeNode)this.getRootNode()).getPath(), null, null);
    }
}

