/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class NeoTabbedPaneUI
extends BasicTabbedPaneUI {
    private final Color borderColor = new Color(165, 165, 165);
    private final Color innerBorderColor = new Color(248, 248, 248);

    public static ComponentUI createUI(JComponent c) {
        return new NeoTabbedPaneUI();
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Graphics2D g2d = (Graphics2D)g;
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        int sr = -1;
        int sc = -1;
        int scr = -1;
        for (int i = this.runCount - 1; i >= 0; --i) {
            int col = 0;
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            int colsInRow = end - start + 1;
            for (int j = start; j <= end; ++j) {
                if (j != selectedIndex && this.rects[j].intersects(clipRect)) {
                    this.paintTab(g2d, tabPlacement, this.rects, this.runCount - 1 - i, col, colsInRow, j, iconRect, textRect);
                }
                if (j == selectedIndex) {
                    sr = this.runCount - 1 - i;
                    sc = col;
                    scr = colsInRow;
                }
                ++col;
            }
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g2d, tabPlacement, this.rects, sr, sc, scr, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTab(Graphics2D g2d, int tabPlacement, Rectangle[] rects, int row, int col, int colsInRow, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean customTabComponent;
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        this.paintTabBackground(g2d, tabPlacement, row, col, colsInRow, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = SwingUtils.getFontMetrics(this.tabPane, g2d, font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        boolean bl = customTabComponent = this.tabPane.getTabComponentAt(tabIndex) == null;
        if (customTabComponent) {
            this.paintIcon(g2d, tabPlacement, tabIndex, icon, iconRect, isSelected);
            this.paintText(g2d, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Map aa = SwingUtils.setupTextAntialias(g);
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                g.setColor(fg);
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
        SwingUtils.restoreTextAntialias(g, aa);
    }

    protected void paintTabBackground(Graphics2D g2d, int tabPlacement, int row, int col, int colsInRow, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean trailingBorder;
        if (isSelected) {
            g2d.setPaint(new GradientPaint(x, y, Color.WHITE, x, y + h, new Color(232, 232, 232)));
            g2d.fillRect(x + 1, y, w - 2, h);
        } else {
            g2d.setPaint(new GradientPaint(x, y, new Color(226, 226, 226), x, y + h, new Color(205, 205, 205)));
            g2d.fillRect(x, y, w, h);
        }
        boolean topBorder = row > 0;
        boolean bl = trailingBorder = this.runCount == 1 || col < colsInRow - 1;
        if (isSelected) {
            g2d.setColor(this.borderColor);
            if (topBorder) {
                g2d.drawLine(x, y, x + w - 1, y);
            }
            if (trailingBorder) {
                g2d.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
            }
            g2d.setColor(this.innerBorderColor);
            g2d.drawLine(x, y + 1, x, y + h - 1);
            g2d.drawLine(x + 1, y + (topBorder ? 1 : 0), x + w - (trailingBorder ? 2 : 1), y + (topBorder ? 1 : 0));
            g2d.drawLine(x + w - (trailingBorder ? 2 : 1), y + 1, x + w - (trailingBorder ? 2 : 1), y + h - 1);
        } else {
            if (row == 0) {
                g2d.setPaint(new Color(191, 191, 191));
                g2d.drawLine(x, y, x + w - 1, y);
            }
            g2d.setPaint(new Color(191, 191, 191));
            g2d.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g2d.setPaint(new Color(200, 200, 200));
            g2d.drawLine(x, y + h - 2, x + w - 1, y + h - 2);
            g2d.setColor(this.borderColor);
            if (topBorder) {
                g2d.drawLine(x, y, x + w - 1, y);
            }
            if (trailingBorder) {
                g2d.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (topBorder) {
                g2d.setPaint(this.innerBorderColor);
                g2d.drawLine(x, y + 1, x + w - 2, y + 1);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
            }
        }
        switch (tabPlacement) {
            default: 
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(new GradientPaint(x, y + 1, new Color(232, 232, 232), x, y + 3, new Color(230, 230, 230)));
        g2d.fillRect(x, y + 1, w, 3);
        g2d.setPaint(this.borderColor);
        g2d.drawLine(x, y, x + w, y);
        g2d.setPaint(this.innerBorderColor);
        g2d.drawLine(x, y + 1, x, y + 3);
        g2d.drawLine(x + w - 1, y + 1, x + w - 1, y + 3);
        g2d.drawLine(x, y + 1, x + w, y + 1);
        g2d.setPaint(new Color(184, 184, 184));
        g2d.drawLine(x, y + 4, x + w, y + 4);
    }
}

