/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.utils.SwingUtils;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;

public final class MenuUtils
implements SwingConstants {
    public static int getIconPlaceholderWidth(JMenuItem menuItem, boolean alignTextToMenuIcons) {
        if (alignTextToMenuIcons && menuItem.getParent() instanceof JPopupMenu) {
            int max = 0;
            JPopupMenu popupMenu = (JPopupMenu)menuItem.getParent();
            for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
                Component component = popupMenu.getComponent(i);
                if (!(component instanceof JMenuItem)) continue;
                JMenuItem otherItem = (JMenuItem)component;
                if (otherItem.getIcon() != null) {
                    max = Math.max(max, otherItem.getIcon().getIconWidth());
                    continue;
                }
                if (!(component instanceof JCheckBoxMenuItem) && !(component instanceof JRadioButtonMenuItem)) continue;
                max = Math.max(max, 16);
            }
            return max;
        }
        Icon icon = menuItem.getIcon();
        return icon != null ? icon.getIconWidth() : 0;
    }

    public static String getAcceleratorText(JMenuItem menuItem) {
        KeyStroke accelerator = menuItem.getAccelerator();
        return accelerator != null ? SwingUtils.hotkeyToString(accelerator) : null;
    }
}

