/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list.editor;

import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CompareUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public abstract class AbstractListCellEditor<E extends Component, T>
implements ListCellEditor<E, T> {
    protected int editedCell = -1;
    protected T oldValue;
    protected E editor;
    protected ComponentAdapter editorPositionUpdater;
    protected MouseAdapter mouseAdapter = null;
    protected int clicksToEdit = 2;
    protected KeyAdapter keyAdapter = null;

    @Override
    public void install(final JList list) {
        this.editorPositionUpdater = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.checkEditorBounds();
            }

            private void checkEditorBounds() {
                Rectangle newBounds;
                if (AbstractListCellEditor.this.isEditing() && (newBounds = AbstractListCellEditor.this.getEditorBounds(list, AbstractListCellEditor.this.editedCell, AbstractListCellEditor.this.oldValue)) != null && !newBounds.equals(((Component)AbstractListCellEditor.this.editor).getBounds())) {
                    ((Component)AbstractListCellEditor.this.editor).setBounds(newBounds);
                    list.revalidate();
                    list.repaint();
                }
            }
        };
        list.addComponentListener(this.editorPositionUpdater);
        this.installStartEditActions(list);
    }

    protected void installStartEditActions(final JList list) {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AbstractListCellEditor.this.getClicksToEdit() > 0 && e.getClickCount() == AbstractListCellEditor.this.getClicksToEdit() && SwingUtilities.isLeftMouseButton(e)) {
                    Rectangle cell;
                    Point point = e.getPoint();
                    int index = list.getUI().locationToIndex(list, point);
                    if (index >= 0 && index < list.getModel().getSize() && (cell = list.getCellBounds(index, index)).contains(point)) {
                        AbstractListCellEditor.this.startEdit(list, index);
                    }
                }
            }
        };
        list.addMouseListener(this.mouseAdapter);
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.F2.isTriggered(e)) {
                    AbstractListCellEditor.this.startEdit(list, list.getSelectedIndex());
                }
            }
        };
        list.addKeyListener(this.keyAdapter);
    }

    @Override
    public void uninstall(JList list) {
        list.removeComponentListener(this.editorPositionUpdater);
        this.uninstallStartEditActions(list);
    }

    protected void uninstallStartEditActions(JList list) {
        if (this.mouseAdapter != null) {
            list.removeMouseListener(this.mouseAdapter);
        }
        if (this.keyAdapter != null) {
            list.removeKeyListener(this.keyAdapter);
        }
    }

    @Override
    public boolean isCellEditable(JList list, int index, T value) {
        if (list instanceof WebList) {
            return ((WebList)list).isEditable() && list.isEnabled();
        }
        return list.isEnabled();
    }

    @Override
    public E getCellEditor(JList list, int index, T value) {
        this.editor = this.createCellEditor(list, index, value);
        this.createCellEditorListeners(list, index, value);
        return this.editor;
    }

    protected abstract E createCellEditor(JList var1, int var2, T var3);

    protected void createCellEditorListeners(final JList list, int index, T value) {
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractListCellEditor.this.stopEdit(list);
            }
        };
        ((Component)this.editor).addFocusListener(focusAdapter);
        ((Component)this.editor).addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.ENTER.isTriggered(e)) {
                    ((Component)AbstractListCellEditor.this.editor).removeFocusListener(focusAdapter);
                    AbstractListCellEditor.this.stopEdit(list);
                    list.requestFocusInWindow();
                } else if (Hotkey.ESCAPE.isTriggered(e)) {
                    ((Component)AbstractListCellEditor.this.editor).removeFocusListener(focusAdapter);
                    AbstractListCellEditor.this.cancelEdit(list);
                    list.requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public void startEdit(JList list, int index) {
        if (index == -1) {
            return;
        }
        this.oldValue = list.getModel().getElementAt(index);
        if (!this.isCellEditable(list, index, this.oldValue)) {
            this.oldValue = null;
            return;
        }
        this.editor = this.getCellEditor(list, index, this.oldValue);
        ((Component)this.editor).setBounds(this.getEditorBounds(list, index, this.oldValue));
        this.addEditor(list);
        if (((Component)this.editor).isFocusable()) {
            ((Component)this.editor).requestFocusInWindow();
        }
        this.editStarted(list, index);
    }

    @Override
    public void cancelEdit(JList list) {
        this.removeEditor(list);
        this.editCancelled(list, this.editedCell);
    }

    @Override
    public boolean stopEdit(JList list) {
        if (!this.isEditing()) {
            return false;
        }
        int[] indices = list.getSelectedIndices();
        T newValue = this.getCellEditorValue(list, this.editedCell, this.oldValue);
        boolean changed = this.updateListModel(list, this.editedCell, this.oldValue, newValue, true);
        this.removeEditor(list);
        if (changed) {
            list.setSelectedIndices(indices);
            this.editStopped(list, this.editedCell, this.oldValue, newValue);
        } else {
            this.editCancelled(list, this.editedCell);
        }
        return true;
    }

    protected void addEditor(JList list) {
        list.add((Component)this.editor);
        list.revalidate();
        list.repaint();
    }

    protected void removeEditor(JList list) {
        list.remove((Component)this.editor);
        list.revalidate();
        list.repaint();
    }

    protected Rectangle getEditorBounds(JList list, int index, T value, Rectangle cellBounds) {
        return new Rectangle(0, 0, cellBounds.width, cellBounds.height);
    }

    protected Rectangle getEditorBounds(JList list, int index, T value) {
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (cellBounds != null) {
            Rectangle editorBounds = this.getEditorBounds(list, index, value, cellBounds);
            return new Rectangle(cellBounds.x + editorBounds.x, cellBounds.y + editorBounds.y, editorBounds.width, editorBounds.height);
        }
        return null;
    }

    @Override
    public boolean updateListModel(JList list, int index, T oldValue, T newValue, boolean updateSelection) {
        if (CompareUtils.equals(oldValue, newValue)) {
            return false;
        }
        ListModel model = list.getModel();
        if (model instanceof DefaultListModel) {
            DefaultListModel defaultListModel = (DefaultListModel)model;
            defaultListModel.setElementAt(newValue, index);
            return true;
        }
        if (model instanceof AbstractListModel) {
            final Object[] values = new Object[model.getSize()];
            for (int i = 0; i < model.getSize(); ++i) {
                values[i] = this.editedCell != i ? model.getElementAt(i) : newValue;
            }
            list.setModel(new AbstractListModel(){

                @Override
                public int getSize() {
                    return values.length;
                }

                @Override
                public Object getElementAt(int index) {
                    return values[index];
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void editStarted(JList list, int index) {
        this.editedCell = index;
        if (list instanceof WebList) {
            ((WebList)list).fireEditStarted(index);
        }
    }

    @Override
    public void editStopped(JList list, int index, T oldValue, T newValue) {
        this.editedCell = -1;
        if (list instanceof WebList) {
            ((WebList)list).fireEditFinished(index, oldValue, newValue);
        }
    }

    @Override
    public void editCancelled(JList list, int index) {
        this.editedCell = -1;
        if (list instanceof WebList) {
            ((WebList)list).fireEditCancelled(index);
        }
    }

    @Override
    public boolean isEditing() {
        return this.editedCell != -1;
    }

    public int getClicksToEdit() {
        return this.clicksToEdit;
    }

    public void setClicksToEdit(int clicksToEdit) {
        this.clicksToEdit = clicksToEdit;
    }
}

