/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.global.StyleConstants;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListStyle;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class WebListUI
extends BasicListUI {
    protected boolean decorateSelection = WebListStyle.decorateSelection;
    protected boolean highlightRolloverCell = WebListStyle.highlightRolloverCell;
    protected int selectionRound = WebListStyle.selectionRound;
    protected int selectionShadeWidth = WebListStyle.selectionShadeWidth;
    protected boolean webColoredSelection = WebListStyle.webColoredSelection;
    protected Color selectionBorderColor = WebListStyle.selectionBorderColor;
    protected Color selectionBackgroundColor = WebListStyle.selectionBackgroundColor;
    protected boolean autoScrollToSelection = WebListStyle.autoScrollToSelection;
    protected MouseAdapter mouseAdapter;
    protected ListSelectionListener selectionListener;
    protected int rolloverIndex = -1;

    public static ComponentUI createUI(JComponent c) {
        return new WebListUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.list);
        LookAndFeel.installProperty(this.list, "opaque", Boolean.TRUE);
        this.list.setBackground(new ColorUIResource(WebListStyle.background));
        this.list.setForeground(new ColorUIResource(WebListStyle.foreground));
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.clearMouseover();
            }

            private void updateMouseover(MouseEvent e) {
                int index = WebListUI.this.list.locationToIndex(e.getPoint());
                Rectangle bounds = WebListUI.this.list.getCellBounds(index, index);
                if (WebListUI.this.list.isEnabled() && bounds != null && bounds.contains(e.getPoint())) {
                    if (WebListUI.this.rolloverIndex != index) {
                        this.updateRolloverCell(WebListUI.this.rolloverIndex, index);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                if (WebListUI.this.rolloverIndex != -1) {
                    this.updateRolloverCell(WebListUI.this.rolloverIndex, -1);
                }
            }

            private void updateRolloverCell(int oldIndex, int newIndex) {
                ToolTipProvider<? extends WebList> provider;
                Rectangle newBounds;
                Rectangle oldBounds;
                Rectangle rect;
                WebListUI.this.rolloverIndex = newIndex;
                if (WebListUI.this.decorateSelection && WebListUI.this.highlightRolloverCell && (rect = GeometryUtils.getContainingRect(oldBounds = WebListUI.this.list.getCellBounds(oldIndex, oldIndex), newBounds = WebListUI.this.list.getCellBounds(newIndex, newIndex))) != null) {
                    WebListUI.this.list.repaint(rect);
                }
                if ((provider = WebListUI.this.getToolTipProvider()) != null) {
                    provider.rolloverCellChanged((WebList)WebListUI.this.list, oldIndex, 0, newIndex, 0);
                }
            }
        };
        this.list.addMouseListener(this.mouseAdapter);
        this.list.addMouseMotionListener(this.mouseAdapter);
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (WebListUI.this.autoScrollToSelection && WebListUI.this.list.getSelectedIndex() != -1) {
                    int index = WebListUI.this.list.getLeadSelectionIndex();
                    Rectangle selection = WebListUI.this.getCellBounds(WebListUI.this.list, index, index);
                    if (selection != null && !selection.intersects(WebListUI.this.list.getVisibleRect())) {
                        WebListUI.this.list.scrollRectToVisible(selection);
                    }
                }
            }
        };
        this.list.addListSelectionListener(this.selectionListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.list.removeMouseListener(this.mouseAdapter);
        this.list.removeMouseMotionListener(this.mouseAdapter);
        this.list.removeListSelectionListener(this.selectionListener);
        super.uninstallUI(c);
    }

    protected ToolTipProvider<? extends WebList> getToolTipProvider() {
        return this.list != null && this.list instanceof WebList ? ((WebList)this.list).getToolTipProvider() : null;
    }

    public boolean isDecorateSelection() {
        return this.decorateSelection;
    }

    public void setDecorateSelection(boolean decorateSelection) {
        this.decorateSelection = decorateSelection;
    }

    public boolean isHighlightRolloverCell() {
        return this.highlightRolloverCell;
    }

    public void setHighlightRolloverCell(boolean highlightRolloverCell) {
        this.highlightRolloverCell = highlightRolloverCell;
    }

    public int getSelectionRound() {
        return this.selectionRound;
    }

    public void setSelectionRound(int selectionRound) {
        this.selectionRound = selectionRound;
    }

    public int getSelectionShadeWidth() {
        return this.selectionShadeWidth;
    }

    public void setSelectionShadeWidth(int selectionShadeWidth) {
        this.selectionShadeWidth = selectionShadeWidth;
    }

    public boolean isWebColoredSelection() {
        return this.webColoredSelection;
    }

    public void setWebColoredSelection(boolean webColored) {
        this.webColoredSelection = webColored;
    }

    public Color getSelectionBorderColor() {
        return this.selectionBorderColor;
    }

    public void setSelectionBorderColor(Color color) {
        this.selectionBorderColor = color;
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        this.selectionBackgroundColor = color;
    }

    public boolean isAutoScrollToSelection() {
        return this.autoScrollToSelection;
    }

    public void setAutoScrollToSelection(boolean autoScrollToSelection) {
        this.autoScrollToSelection = autoScrollToSelection;
    }

    protected void paintCell(Graphics g, int index, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(index);
        boolean isSelected = selModel.isSelectedIndex(index);
        if (this.decorateSelection && (isSelected || index == this.rolloverIndex)) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(0.35f), !isSelected);
            Rectangle rect = new Rectangle(rowBounds);
            rect.x += this.selectionShadeWidth;
            rect.y += this.selectionShadeWidth;
            rect.width = rect.width - (this.selectionShadeWidth * 2 + (this.selectionBorderColor != null ? 1 : 0));
            rect.height = rect.height - (this.selectionShadeWidth * 2 + (this.selectionBorderColor != null ? 1 : 0));
            LafUtils.drawCustomWebBorder(g2d, this.list, new RoundRectangle2D.Double(rect.x, rect.y, rect.width, rect.height, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, this.webColoredSelection, this.selectionBorderColor, this.selectionBorderColor, this.selectionBackgroundColor);
            GraphicsUtils.restoreComposite(g2d, oc, !isSelected);
        }
        boolean cellHasFocus = this.list.hasFocus() && index == leadIndex;
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, index, isSelected, cellHasFocus);
        this.rendererPane.paintComponent(g, rendererComponent, this.list, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
    }
}

