/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.extended.layout.TableLayout;
import com.alee.laf.colorchooser.LineColorChooserPaint;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LineColorChooser
extends WebPanel {
    public static final ImageIcon LEFT_ICON = new ImageIcon(LineColorChooser.class.getResource("icons/left.png"));
    public static final ImageIcon RIGHT_ICON = new ImageIcon(LineColorChooser.class.getResource("icons/right.png"));
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private final LineColorChooserPaint lineColorChooserPaint = new LineColorChooserPaint(2, 256);
    private final LinePalette colorLine;
    private int hue = 0;
    private boolean webOnlyColors = false;

    public LineColorChooser() {
        this.setLayout(new TableLayout(new double[][]{{10.0, -2.0, 10.0}, {3.0, -2.0, 3.0}}));
        this.colorLine = new LinePalette();
        this.add((Component)this.colorLine, (Object)"1,1");
        ColorLineMouseAdapter adapter = new ColorLineMouseAdapter();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    private void setHue(int hue, boolean fireEvent) {
        if (this.hue == hue) {
            return;
        }
        if (hue < 0) {
            hue = 0;
        } else if (hue > 360) {
            hue = 360;
        }
        this.hue = hue;
        this.repaint();
        if (fireEvent) {
            this.firePropertyChanged();
        }
    }

    public int getHue() {
        return 360 - this.hue;
    }

    public void setColor(Color color) {
        this.setHue(360 - Math.round(360.0f * Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0]), false);
    }

    public Color getColor() {
        return this.lineColorChooserPaint.getColor(Math.round((float)(this.colorLine.getHeight() - 4) * (float)this.hue / 360.0f));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.drawImage(LEFT_ICON.getImage(), 1, 1 + Math.round((float)this.hue / 360.0f * (float)(this.colorLine.getHeight() - 5)), LEFT_ICON.getImageObserver());
        g.drawImage(RIGHT_ICON.getImage(), this.getWidth() - RIGHT_ICON.getIconWidth() - 1, 1 + Math.round((float)this.hue / 360.0f * (float)(this.colorLine.getHeight() - 5)), RIGHT_ICON.getImageObserver());
    }

    public boolean isWebOnlyColors() {
        return this.webOnlyColors;
    }

    public void setWebOnlyColors(boolean webOnlyColors) {
        this.webOnlyColors = webOnlyColors;
        this.lineColorChooserPaint.setWebSafe(webOnlyColors);
        this.repaint();
        this.firePropertyChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void firePropertyChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private class ColorLineMouseAdapter
    extends MouseAdapter {
        private ColorLineMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.updateHue(e.getY());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateHue(e.getY());
        }

        private void updateHue(int yCoordinate) {
            LineColorChooser.this.setHue(Math.round(360.0f * ((float)(yCoordinate - 5) / (float)(LineColorChooser.this.colorLine.getHeight() - 4))), true);
        }
    }

    private class LinePalette
    extends JComponent {
        public LinePalette() {
            SwingUtils.setOrientation(this);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(Color.GRAY);
            g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2d.setPaint(Color.WHITE);
            g2d.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            g2d.setPaint(LineColorChooser.this.lineColorChooserPaint);
            g2d.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(22, 260);
        }
    }
}

