/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.extended.syntax.PresetType;
import com.alee.extended.syntax.SyntaxTheme;
import com.alee.extended.syntax.WebSyntaxArea;
import com.alee.global.StyleConstants;
import com.alee.utils.FileUtils;
import java.awt.Color;
import java.awt.Insets;
import java.io.File;

public enum SyntaxPreset {
    base(PresetType.settings){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setAntiAliasingEnabled(true);
            syntaxArea.setUseFocusableTips(true);
            syntaxArea.setTabSize(4);
            syntaxArea.setCodeFoldingEnabled(true);
            syntaxArea.setPaintTabLines(false);
            syntaxArea.setWhitespaceVisible(false);
            syntaxArea.setEOLMarkersVisible(false);
        }
    }
    ,
    size(PresetType.style){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setRows(4);
            syntaxArea.setColumns(1);
        }
    }
    ,
    margin(PresetType.style){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setMargin(new Insets(5, 5, 5, 5));
        }
    }
    ,
    historyLimit(PresetType.settings){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.getUndoManager().setLimit(50);
        }
    }
    ,
    viewable(PresetType.settings){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setEditable(false);
        }
    }
    ,
    editable(PresetType.settings){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setEditable(true);
        }
    }
    ,
    hideMenu(PresetType.settings){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setPopupMenu(null);
        }
    }
    ,
    transparent(PresetType.style){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setBackground(StyleConstants.transparent);
            syntaxArea.setOpaque(false);
        }
    }
    ,
    opaque(PresetType.style){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setBackground(Color.WHITE);
            syntaxArea.setOpaque(true);
        }
    }
    ,
    java(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/java");
        }
    }
    ,
    xml(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/xml");
        }
    }
    ,
    html(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/html");
        }
    }
    ,
    css(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/css");
        }
    }
    ,
    js(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/javascript");
        }
    }
    ,
    php(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/php");
        }
    }
    ,
    sql(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/sql");
        }
    }
    ,
    none(PresetType.syntax){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/plain");
        }
    }
    ,
    ideaTheme(PresetType.theme){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            SyntaxTheme.idea.apply(syntaxArea);
        }
    }
    ,
    darkTheme(PresetType.theme){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            SyntaxTheme.dark.apply(syntaxArea);
        }
    }
    ,
    vsTheme(PresetType.theme){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            SyntaxTheme.vs.apply(syntaxArea);
        }
    }
    ,
    eclipseTheme(PresetType.theme){

        @Override
        public void apply(WebSyntaxArea syntaxArea) {
            SyntaxTheme.eclipse.apply(syntaxArea);
        }
    };

    private final PresetType type;

    private SyntaxPreset(PresetType type) {
        this.type = type;
    }

    public PresetType getType() {
        return this.type;
    }

    public abstract void apply(WebSyntaxArea var1);

    public static SyntaxPreset getSyntaxPreset(File file) {
        return SyntaxPreset.getSyntaxPreset(file.getName());
    }

    public static SyntaxPreset getSyntaxPreset(String file) {
        String ext;
        String fe = FileUtils.getFileExtPart(file, false);
        String string = ext = fe.length() > 0 ? fe.toLowerCase() : file;
        if (ext.contains("java")) {
            return java;
        }
        if (ext.contains("xml")) {
            return xml;
        }
        if (ext.contains("htm")) {
            return html;
        }
        if (ext.contains("css")) {
            return css;
        }
        if (ext.contains("js") || ext.contains("javascript")) {
            return js;
        }
        if (ext.contains("php")) {
            return php;
        }
        if (ext.contains("sql")) {
            return sql;
        }
        return none;
    }
}

