/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.statusbar.WebStatusBarStyle;
import com.alee.global.StyleConstants;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.toolbar.WhiteSpace;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class WebStatusBar
extends JComponent
implements LanguageContainerMethods {
    private Color topBgColor = WebStatusBarStyle.topBgColor;
    private Color bottomBgColor = WebStatusBarStyle.bottomBgColor;
    private Insets margin = WebStatusBarStyle.margin;
    private boolean undecorated = WebStatusBarStyle.undecorated;

    public WebStatusBar() {
        SwingUtils.setOrientation(this);
        this.setLayout(new ToolbarLayout());
        this.updateBorder();
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public void addSeparator() {
        this.addSeparator("START");
    }

    public void addSeparatorToEnd() {
        this.addSeparator("END");
    }

    public void addSeparator(String constraints) {
        this.add((Component)WebStatusBar.createSeparator(), constraints);
    }

    public void addToMiddle(Component component) {
        this.add(component, "MIDDLE");
    }

    public void addFill(Component component) {
        this.add(component, "FILL");
    }

    public void addToEnd(Component component) {
        this.add(component, "END");
    }

    public void addSpacing() {
        this.addSpacing(StyleConstants.contentSpacing);
    }

    public void addSpacing(int spacing) {
        this.addSpacing(spacing, "START");
    }

    public void addSpacingToEnd() {
        this.addSpacingToEnd(StyleConstants.contentSpacing);
    }

    public void addSpacingToEnd(int spacing) {
        this.addSpacing(spacing, "END");
    }

    public void addSpacing(int spacing, String constrain) {
        this.add((Component)new WhiteSpace(spacing), constrain);
    }

    private void updateBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(this.margin.top + (this.undecorated ? 0 : 1), this.margin.left, this.margin.bottom, this.margin.right));
    }

    public ToolbarLayout getActualLayout() {
        return (ToolbarLayout)this.getLayout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.undecorated) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setPaint(StyleConstants.darkBorderColor);
            g2d.drawLine(0, 0, this.getWidth() - 1, 0);
        }
    }

    private static WebSeparator createSeparator() {
        return new WebSeparator(1);
    }

    @Override
    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer(this, key);
    }

    @Override
    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer(this);
    }

    @Override
    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey(this);
    }
}

