/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.WebStatusLabel;
import com.alee.utils.SwingUtils;
import java.awt.AWTEvent;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class WebCursorTracker
extends WebStatusLabel {
    public static final ImageIcon CURSOR_ICON = new ImageIcon(WebCursorTracker.class.getResource("icons/cursor.png"));
    private AWTEventListener listener = null;

    public WebCursorTracker() {
        this.setIcon(CURSOR_ICON);
        this.listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)event;
                    if (event.getID() == 504) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
                        WebCursorTracker.this.updatePosition(e);
                    } else if (event.getID() == 505) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        Toolkit.getDefaultToolkit().addAWTEventListener(WebCursorTracker.this.listener, 16L);
                        WebCursorTracker.this.updatePosition(e);
                    } else if (event.getID() == 503 || event.getID() == 506) {
                        WebCursorTracker.this.updatePosition(e);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 16L);
    }

    private void updatePosition(final MouseEvent e) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e != null && e.getComponent() != null && SwingUtils.getWindowAncestor(e.getComponent()) != null) {
                    Point wl = SwingUtils.getWindowAncestor(e.getComponent()).getLocation();
                    Point ml = MouseInfo.getPointerInfo().getLocation();
                    WebCursorTracker.this.setText("x:" + (ml.x - wl.x) + " y:" + (ml.y - wl.y));
                } else {
                    WebCursorTracker.this.setText("Outside of area");
                }
            }
        });
    }
}

