/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.painter.Painter;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebButtonUI;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.swing.UnselectableButtonGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebButtonGroup
extends WebPanel
implements SwingConstants {
    protected int orientation = -1;
    protected boolean group = false;
    protected UnselectableButtonGroup buttonGroup;
    protected PropertyChangeListener enabledStateListener;

    public WebButtonGroup(JComponent ... component) {
        this(0, component);
    }

    public WebButtonGroup(boolean group, JComponent ... component) {
        this(0, group, component);
    }

    public WebButtonGroup(int orientation, JComponent ... components) {
        this(orientation, false, components);
    }

    public WebButtonGroup(int orientation, final boolean group, JComponent ... components) {
        this.group = group;
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.setOpaque(false);
        this.setOrientation(orientation);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (group) {
                    WebButtonGroup.this.groupButtons(e.getComponent());
                }
                WebButtonGroup.this.updateButtonsStyling();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (group) {
                    WebButtonGroup.this.ungroupButtons(e.getComponent());
                }
                WebButtonGroup.this.updateButtonsStyling();
            }
        });
        this.enabledStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JButton src;
                int zOrder;
                Object source = evt.getSource();
                if (source instanceof JButton && (zOrder = WebButtonGroup.this.getComponentZOrder(src = (JButton)source)) != -1) {
                    if (zOrder > 0) {
                        WebButtonGroup.this.getComponent(zOrder - 1).repaint();
                    }
                    if (zOrder < WebButtonGroup.this.getComponentCount() - 1) {
                        WebButtonGroup.this.getComponent(zOrder + 1).repaint();
                    }
                }
            }
        };
        this.add(components);
    }

    public WebButton getWebButton(int index) {
        return (WebButton)this.getComponent(index);
    }

    public WebButton getWebButton(String name) {
        for (Component component : this.getComponents()) {
            if (!component.getName().equals(name)) continue;
            return (WebButton)component;
        }
        return null;
    }

    public boolean isAnySelected() {
        return this.buttonGroup.getSelection() != null && this.buttonGroup.getSelection().isSelected();
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        if (this.group != group) {
            this.group = group;
            if (group) {
                this.groupButtons(this);
            } else {
                this.ungroupButtons(this);
            }
        }
    }

    public UnselectableButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new UnselectableButtonGroup();
            this.buttonGroup.setUnselectable(false);
        }
        return this.buttonGroup;
    }

    protected void groupButtons(Component component) {
        if (this.isButton(component)) {
            this.getButtonGroup().add((AbstractButton)component);
        } else if (this.isWebButtonGroup(component)) {
            WebButtonGroup innerGroup = (WebButtonGroup)component;
            for (Component innerComponent : innerGroup.getComponents()) {
                this.groupButtons(innerComponent);
            }
        }
    }

    protected void ungroupButtons(Component component) {
        if (this.isButton(component)) {
            this.getButtonGroup().remove((AbstractButton)component);
        } else if (this.isWebButtonGroup(component)) {
            WebButtonGroup innerGroup = (WebButtonGroup)component;
            for (Component innerComponent : innerGroup.getComponents()) {
                this.ungroupButtons(innerComponent);
            }
        }
    }

    public boolean isUnselectable() {
        return this.getButtonGroup().isUnselectable();
    }

    public void setUnselectable(boolean unselectable) {
        this.getButtonGroup().setUnselectable(unselectable);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.setLayout(orientation == 0 ? new HorizontalFlowLayout(0, false) : new VerticalFlowLayout(0, 0, 0, true, false));
            this.updateButtonsStyling();
        }
    }

    protected void updateButtonsStyling() {
        Component[] components = this.getComponents();
        boolean horizontal = this.orientation == 0;
        boolean lastWasButton = false;
        for (int i = 0; i < components.length; ++i) {
            if (this.isWebStyledButton(components[i])) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)components[i]).getUI();
                if (lastWasButton) {
                    if (horizontal) {
                        ui.setDrawLeft(false);
                        ui.setDrawLeftLine(false);
                    } else {
                        ui.setDrawTop(false);
                        ui.setDrawTopLine(false);
                    }
                }
                if (i < components.length - 1 && (this.isWebStyledButton(components[i + 1]) || this.isWebButtonGroup(components[i + 1]))) {
                    if (horizontal) {
                        ui.setDrawRight(false);
                        ui.setDrawRightLine(true);
                    } else {
                        ui.setDrawBottom(false);
                        ui.setDrawBottomLine(true);
                    }
                }
                lastWasButton = true;
                continue;
            }
            if (this.isWebButtonGroup(components[i])) {
                WebButtonUI ui;
                WebButtonGroup wbg = (WebButtonGroup)components[i];
                if (lastWasButton) {
                    for (Component component : wbg.getComponents()) {
                        if (!this.isWebStyledButton(component)) continue;
                        ui = (WebButtonUI)((AbstractButton)component).getUI();
                        if (horizontal) {
                            ui.setDrawLeft(false);
                            ui.setDrawLeftLine(false);
                            continue;
                        }
                        ui.setDrawTop(false);
                        ui.setDrawTopLine(false);
                    }
                }
                if (i < components.length - 1 && (this.isWebStyledButton(components[i + 1]) || this.isWebButtonGroup(components[i + 1]))) {
                    for (Component component : wbg.getComponents()) {
                        if (!this.isWebStyledButton(component)) continue;
                        ui = (WebButtonUI)((AbstractButton)component).getUI();
                        if (horizontal) {
                            ui.setDrawRight(false);
                            ui.setDrawRightLine(true);
                            continue;
                        }
                        ui.setDrawBottom(false);
                        ui.setDrawBottomLine(true);
                    }
                }
                lastWasButton = true;
                continue;
            }
            lastWasButton = false;
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        comp.addPropertyChangeListener("enabled", this.enabledStateListener);
    }

    @Override
    public void remove(int index) {
        this.getComponent(index).removePropertyChangeListener("enabled", this.enabledStateListener);
        super.remove(index);
    }

    protected boolean isButton(Component component) {
        return component instanceof AbstractButton;
    }

    protected boolean isWebStyledButton(Component component) {
        return this.isButton(component) && ((AbstractButton)component).getUI() instanceof WebButtonUI;
    }

    protected boolean isWebButtonGroup(Component component) {
        return component instanceof WebButtonGroup;
    }

    public void setButtonsFocusable(boolean focusable) {
        this.setFocusable(this, focusable);
    }

    protected void setFocusable(WebButtonGroup group, boolean focusable) {
        for (Component component : group.getComponents()) {
            if (this.isWebButtonGroup(component)) {
                this.setFocusable((WebButtonGroup)component, focusable);
                continue;
            }
            component.setFocusable(focusable);
        }
    }

    public void setButtonsForeground(Color foreground) {
        this.setForeground(this, foreground);
    }

    protected void setForeground(WebButtonGroup group, Color foreground) {
        for (Component component : group.getComponents()) {
            if (this.isWebButtonGroup(component)) {
                this.setForeground((WebButtonGroup)component, foreground);
                continue;
            }
            component.setForeground(foreground);
        }
    }

    public void setButtonsSelectedForeground(Color selectedForeground) {
        this.setSelectedForeground(this, selectedForeground);
    }

    protected void setSelectedForeground(WebButtonGroup group, Color selectedForeground) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setSelectedForeground(selectedForeground);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setSelectedForeground((WebButtonGroup)component, selectedForeground);
        }
    }

    public void setButtonsDrawTop(boolean drawTop) {
        this.setDrawTop(this, drawTop);
    }

    protected void setDrawTop(WebButtonGroup group, boolean drawTop) {
        if (this.orientation == 0) {
            for (Component component : group.getComponents()) {
                this.setDrawTop(component, drawTop);
            }
        } else {
            this.setDrawTop(this.getFirstComponent(), drawTop);
        }
    }

    protected void setDrawTop(Component component, boolean drawTop) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
            ui.setDrawTop(drawTop);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawTop((WebButtonGroup)component, drawTop);
        }
    }

    public void setButtonsDrawLeft(boolean drawLeft) {
        this.setDrawLeft(this, drawLeft);
    }

    protected void setDrawLeft(WebButtonGroup group, boolean drawLeft) {
        if (this.orientation == 1) {
            for (Component component : group.getComponents()) {
                this.setDrawLeft(component, drawLeft);
            }
        } else {
            this.setDrawLeft(this.getFirstComponent(), drawLeft);
        }
    }

    protected void setDrawLeft(Component component, boolean drawLeft) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
            ui.setDrawLeft(drawLeft);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawLeft((WebButtonGroup)component, drawLeft);
        }
    }

    public void setButtonsDrawBottom(boolean drawBottom) {
        this.setDrawBottom(this, drawBottom);
    }

    protected void setDrawBottom(WebButtonGroup group, boolean drawBottom) {
        if (this.orientation == 0) {
            for (Component component : group.getComponents()) {
                this.setDrawBottom(component, drawBottom);
            }
        } else {
            this.setDrawBottom(this.getLastComponent(), drawBottom);
        }
    }

    protected void setDrawBottom(Component component, boolean drawBottom) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
            ui.setDrawBottom(drawBottom);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawBottom((WebButtonGroup)component, drawBottom);
        }
    }

    public void setButtonsDrawRight(boolean drawRight) {
        this.setDrawRight(this, drawRight);
    }

    protected void setDrawRight(WebButtonGroup group, boolean drawRight) {
        if (this.orientation == 1) {
            for (Component component : group.getComponents()) {
                this.setDrawRight(component, drawRight);
            }
        } else {
            this.setDrawRight(this.getLastComponent(), drawRight);
        }
    }

    protected void setDrawRight(Component component, boolean drawRight) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
            ui.setDrawRight(drawRight);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawRight((WebButtonGroup)component, drawRight);
        }
    }

    public void setButtonsDrawSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.setButtonsDrawTop(top);
        this.setButtonsDrawLeft(left);
        this.setButtonsDrawBottom(bottom);
        this.setButtonsDrawRight(right);
    }

    public void setButtonsRolloverDarkBorderOnly(boolean rolloverDarkBorderOnly) {
        this.setRolloverDarkBorderOnly(this, rolloverDarkBorderOnly);
    }

    protected void setRolloverDarkBorderOnly(WebButtonGroup group, boolean rolloverDarkBorderOnly) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setRolloverDarkBorderOnly(rolloverDarkBorderOnly);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverDarkBorderOnly((WebButtonGroup)component, rolloverDarkBorderOnly);
        }
    }

    public void setButtonsRolloverShine(boolean rolloverShine) {
        this.setRolloverShine(this, rolloverShine);
    }

    protected void setRolloverShine(WebButtonGroup group, boolean rolloverShine) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setRolloverShine(rolloverShine);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverShine((WebButtonGroup)component, rolloverShine);
        }
    }

    public void setButtonsShineColor(Color shineColor) {
        this.setShineColor(this, shineColor);
    }

    protected void setShineColor(WebButtonGroup group, Color shineColor) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setShineColor(shineColor);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setShineColor((WebButtonGroup)component, shineColor);
        }
    }

    public void setButtonsRound(int round) {
        this.setRound(this, round);
    }

    protected void setRound(WebButtonGroup group, int round) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setRound(round);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRound((WebButtonGroup)component, round);
        }
    }

    public void setButtonsRolloverShadeOnly(boolean rolloverShadeOnly) {
        this.setRolloverShadeOnly(this, rolloverShadeOnly);
    }

    protected void setRolloverShadeOnly(WebButtonGroup group, boolean rolloverShadeOnly) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setRolloverShadeOnly(rolloverShadeOnly);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverShadeOnly((WebButtonGroup)component, rolloverShadeOnly);
        }
    }

    public void setButtonsShadeWidth(int shadeWidth) {
        this.setShadeWidth(this, shadeWidth);
    }

    protected void setShadeWidth(WebButtonGroup group, int shadeWidth) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setShadeWidth(shadeWidth);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setShadeWidth((WebButtonGroup)component, shadeWidth);
        }
    }

    public void setButtonsShadeColor(Color shadeColor) {
        this.setShadeColor(this, shadeColor);
    }

    protected void setShadeColor(WebButtonGroup group, Color shadeColor) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setShadeColor(shadeColor);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setShadeColor((WebButtonGroup)component, shadeColor);
        }
    }

    public void setButtonsInnerShadeWidth(int innerShadeWidth) {
        this.setInnerShadeWidth(this, innerShadeWidth);
    }

    protected void setInnerShadeWidth(WebButtonGroup group, int innerShadeWidth) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setInnerShadeWidth(innerShadeWidth);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setInnerShadeWidth((WebButtonGroup)component, innerShadeWidth);
        }
    }

    public void setButtonsInnerShadeColor(Color innerShadeColor) {
        this.setInnerShadeColor(this, innerShadeColor);
    }

    protected void setInnerShadeColor(WebButtonGroup group, Color innerShadeColor) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setInnerShadeColor(innerShadeColor);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setInnerShadeColor((WebButtonGroup)component, innerShadeColor);
        }
    }

    public void setButtonsLeftRightSpacing(int leftRightSpacing) {
        this.setLeftRightSpacing(this, leftRightSpacing);
    }

    protected void setLeftRightSpacing(WebButtonGroup group, int leftRightSpacing) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setLeftRightSpacing(leftRightSpacing);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setLeftRightSpacing((WebButtonGroup)component, leftRightSpacing);
        }
    }

    public void setButtonsRolloverDecoratedOnly(boolean rolloverDecoratedOnly) {
        this.setRolloverDecoratedOnly(this, rolloverDecoratedOnly);
    }

    protected void setRolloverDecoratedOnly(WebButtonGroup group, boolean rolloverDecoratedOnly) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setRolloverDecoratedOnly(rolloverDecoratedOnly);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverDecoratedOnly((WebButtonGroup)component, rolloverDecoratedOnly);
        }
    }

    public void setButtonsUndecorated(boolean undecorated) {
        this.setUndecorated(this, undecorated);
    }

    protected void setUndecorated(WebButtonGroup group, boolean undecorated) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setUndecorated(undecorated);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setUndecorated((WebButtonGroup)component, undecorated);
        }
    }

    public void setButtonsPainter(Painter painter) {
        this.setPainter(this, painter);
    }

    protected void setPainter(WebButtonGroup group, Painter painter) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setPainter(painter);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setPainter((WebButtonGroup)component, painter);
        }
    }

    public void setButtonsMoveIconOnPress(boolean moveIconOnPress) {
        this.setMoveIconOnPress(this, moveIconOnPress);
    }

    protected void setMoveIconOnPress(WebButtonGroup group, boolean moveIconOnPress) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setMoveIconOnPress(moveIconOnPress);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setMoveIconOnPress((WebButtonGroup)component, moveIconOnPress);
        }
    }

    public void setButtonsDrawFocus(boolean drawFocus) {
        this.setDrawFocus(this, drawFocus);
    }

    protected void setDrawFocus(WebButtonGroup group, boolean drawFocus) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setDrawFocus(drawFocus);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setDrawFocus((WebButtonGroup)component, drawFocus);
        }
    }

    public void setButtonsMargin(Insets margin) {
        this.setMargin(this, margin);
    }

    public void setButtonsMargin(int top, int left, int bottom, int right) {
        this.setButtonsMargin(new Insets(top, left, bottom, right));
    }

    public void setButtonsMargin(int spacing) {
        this.setButtonsMargin(spacing, spacing, spacing, spacing);
    }

    protected void setMargin(WebButtonGroup group, Insets margin) {
        for (Component component : group.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI ui = (WebButtonUI)((AbstractButton)component).getUI();
                ui.setMargin(margin);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setMargin((WebButtonGroup)component, margin);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
    }
}

