/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import com.alee.global.StyleConstants;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class WebStylePainter<E extends JComponent>
extends AbstractPainter<E> {
    protected boolean drawBackground = true;
    protected int round = StyleConstants.smallRound;
    protected boolean drawFocus = false;
    protected int shadeWidth = StyleConstants.shadeWidth;
    protected boolean fillBackground = true;
    protected boolean webColored = true;

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
        this.repaint();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.repaint();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
        this.repaint();
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateAll();
    }

    public boolean isFillBackground() {
        return this.fillBackground;
    }

    public void setFillBackground(boolean fillBackground) {
        this.fillBackground = fillBackground;
        this.repaint();
    }

    public boolean isWebColored() {
        return this.webColored;
    }

    public void setWebColored(boolean webColored) {
        this.webColored = webColored;
        this.repaint();
    }

    @Override
    public Insets getMargin(E c) {
        return new Insets(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.drawBackground) {
            LafUtils.drawWebStyle(g2d, c, this.drawFocus && ((Component)c).isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, this.fillBackground, this.webColored);
        }
    }
}

