/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterListener;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;

public final class PainterSupport {
    private static final Map<JComponent, Map<Painter, PainterListener>> installedPainters = new WeakHashMap<JComponent, Map<Painter, PainterListener>>();

    public static void installPainter(JComponent component, Painter painter) {
        if (component == null || painter == null) {
            return;
        }
        Map<Painter, PainterListener> listeners = installedPainters.get(component);
        if (listeners == null) {
            listeners = new WeakHashMap<Painter, PainterListener>(1);
            installedPainters.put(component, listeners);
        }
        if (!installedPainters.containsKey(painter)) {
            painter.install(component);
            Boolean opaque = painter.isOpaque(component);
            if (opaque != null) {
                LookAndFeel.installProperty(component, "opaque", opaque != false ? Boolean.TRUE : Boolean.FALSE);
            }
            LafUtils.updateBorder(component);
            final WeakReference<JComponent> c = new WeakReference<JComponent>(component);
            final WeakReference<Painter> p = new WeakReference<Painter>(painter);
            PainterListener listener = new PainterListener(){

                @Override
                public void repaint() {
                    ((JComponent)c.get()).repaint();
                }

                @Override
                public void repaint(int x, int y, int width, int height) {
                    ((JComponent)c.get()).repaint(x, y, width, height);
                }

                @Override
                public void revalidate() {
                    LafUtils.updateBorder((Component)c.get());
                    ((JComponent)c.get()).revalidate();
                }

                @Override
                public void updateOpacity() {
                    Boolean opaque;
                    Painter painter = (Painter)p.get();
                    if (painter != null && (opaque = painter.isOpaque((JComponent)c.get())) != null) {
                        ((JComponent)c.get()).setOpaque(opaque);
                    }
                }
            };
            painter.addPainterListener(listener);
            listeners.put(painter, listener);
        }
    }

    public static void uninstallPainter(JComponent component, Painter painter) {
        if (component == null || painter == null) {
            return;
        }
        Map<Painter, PainterListener> listeners = installedPainters.get(component);
        if (listeners != null) {
            painter.uninstall(component);
            listeners.remove(painter);
        }
    }
}

