/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.FileElement;
import com.alee.extended.list.WebFileList;
import com.alee.global.GlobalConstants;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.concurrent.DaemonThreadFactory;
import com.alee.utils.file.FileThumbnailProvider;
import java.awt.Dimension;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class ThumbnailGenerator
implements Runnable {
    protected static final ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    protected static final Map<FileElement, ThumbnailGenerator> generators = new WeakHashMap<FileElement, ThumbnailGenerator>();
    protected static final Object generatorsLock = new Object();
    private final WebFileList list;
    private final FileElement element;
    private final boolean disabled;
    private boolean aborted;

    public ThumbnailGenerator(WebFileList list, FileElement element, boolean disabled) {
        this.list = list;
        this.element = element;
        this.disabled = disabled;
        this.aborted = false;
    }

    public WebFileList getList() {
        return this.list;
    }

    public FileElement getElement() {
        return this.element;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    @Override
    public void run() {
        if (this.aborted) {
            this.cleanup();
            return;
        }
        this.createThumbnail(this.element.getFile(), this.list.isGenerateThumbnails());
        if (this.aborted) {
            this.cleanup();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ThumbnailGenerator.this.list.repaint(ThumbnailGenerator.this.element);
            }
        });
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = generatorsLock;
        synchronized (object) {
            ThumbnailGenerator generator = generators.get(this.element);
            if (generator == this) {
                Object object2 = this.element.getLock();
                synchronized (object2) {
                    this.element.setThumbnailQueued(false);
                    this.element.setDisabledThumbnailQueued(false);
                }
                generators.remove(this.element);
            }
        }
    }

    private void createThumbnail(File file, boolean preview) {
        FileThumbnailProvider thumbnailProvider = this.list.getThumbnailProvider();
        if (thumbnailProvider != null && thumbnailProvider.accept(file)) {
            ImageIcon thumb;
            Dimension size = new Dimension(50, 50);
            ImageIcon imageIcon = thumb = this.element.getEnabledThumbnail() != null ? this.element.getEnabledThumbnail() : thumbnailProvider.provide(file, size, preview);
            if (thumb != null) {
                this.applyThumbnail(thumb);
            } else {
                this.createStandardThumbnail(file, preview);
            }
        } else {
            this.createStandardThumbnail(file, preview);
        }
    }

    private void createStandardThumbnail(File file, boolean preview) {
        String ext = FileUtils.getFileExtPart(file.getName(), false).toLowerCase();
        if (preview && GlobalConstants.IMAGE_FORMATS.contains(ext)) {
            ImageIcon thumb;
            ImageIcon imageIcon = thumb = this.element.getEnabledThumbnail() != null ? this.element.getEnabledThumbnail() : ImageUtils.createThumbnailIcon(file.getAbsolutePath(), 50);
            if (thumb != null) {
                this.applyThumbnail(thumb);
            } else {
                this.applyStandardIcon(file);
            }
        } else {
            this.applyStandardIcon(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyThumbnail(ImageIcon thumb) {
        if (this.aborted) {
            return;
        }
        Object object = this.element.getLock();
        synchronized (object) {
            if (this.element.isThumbnailQueued()) {
                this.element.setEnabledThumbnail(thumb);
            }
        }
        if (this.aborted) {
            return;
        }
        if (this.disabled) {
            ImageIcon disabledThumbnail = ImageUtils.createDisabledCopy(thumb);
            if (this.aborted) {
                return;
            }
            if (this.element.isDisabledThumbnailQueued()) {
                this.element.setDisabledThumbnail(disabledThumbnail);
            }
        }
    }

    private void applyStandardIcon(File file) {
        if (this.aborted) {
            return;
        }
        ImageIcon enabledThumbnail = FileUtils.getStandartFileIcon(file, true, true);
        if (this.aborted) {
            return;
        }
        if (this.element.isThumbnailQueued()) {
            this.element.setEnabledThumbnail(enabledThumbnail);
        }
        if (this.aborted) {
            return;
        }
        if (this.disabled) {
            ImageIcon disabledThumbnail = FileUtils.getStandartFileIcon(file, true, false);
            if (this.aborted) {
                return;
            }
            if (this.element.isDisabledThumbnailQueued()) {
                this.element.setDisabledThumbnail(disabledThumbnail);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueThumbnailLoad(WebFileList list, FileElement element, boolean disabled) {
        Object object = generatorsLock;
        synchronized (object) {
            Object object2 = element.getLock();
            synchronized (object2) {
                if (disabled ? element.isDisabledThumbnailQueued() || element.getDisabledThumbnail() != null : element.isThumbnailQueued() || element.getEnabledThumbnail() != null) {
                    return;
                }
                element.setThumbnailQueued(true);
                element.setDisabledThumbnailQueued(disabled);
            }
            ThumbnailGenerator generator = new ThumbnailGenerator(list, element, disabled);
            generators.put(element, generator);
            executorService.submit(generator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortThumbnailLoad(FileElement element) {
        Object object = generatorsLock;
        synchronized (object) {
            ThumbnailGenerator generator = generators.get(element);
            if (generator != null) {
                generator.abort();
            }
            Object object2 = element.getLock();
            synchronized (object2) {
                element.setEnabledThumbnail(null);
                element.setThumbnailQueued(false);
                element.setDisabledThumbnail(null);
                element.setDisabledThumbnailQueued(false);
            }
        }
    }
}

