/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.layout.RowData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.SwingConstants;

public class WrapFlowLayout
extends AbstractLayoutManager
implements SwingConstants {
    protected boolean fitWidth = true;
    protected boolean fillWidth = true;
    protected int hgap = 0;
    protected int vgap = 0;
    protected int halign = 2;
    protected int valign = 1;
    protected boolean wrapEachComponent = false;
    protected int maxWidth = 0;
    protected int maxHeight = 0;
    protected ArrayList<RowData> rowsData;

    public WrapFlowLayout() {
        this(false);
    }

    public WrapFlowLayout(boolean fillWidth) {
        this(fillWidth, 0, 0);
    }

    public WrapFlowLayout(int hgap, int vgap) {
        this(false, hgap, vgap);
    }

    public WrapFlowLayout(boolean fillWidth, int hgap, int vgap) {
        this.fillWidth = fillWidth;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public boolean isFitWidth() {
        return this.fitWidth;
    }

    public void setFitWidth(boolean fitWidth) {
        this.fitWidth = fitWidth;
    }

    public boolean isFillWidth() {
        return this.fillWidth;
    }

    public void setFillWidth(boolean fillWidth) {
        this.fillWidth = fillWidth;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public boolean isWrapEachComponent() {
        return this.wrapEachComponent;
    }

    public void setWrapEachComponent(boolean wrapEachComponent) {
        this.wrapEachComponent = wrapEachComponent;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public ArrayList<RowData> getRowsData() {
        return this.rowsData;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.layoutContainer(parent);
        return new Dimension(this.maxWidth, this.maxHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.layoutContainer(parent);
        return new Dimension(0, this.maxHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        if (parent.getComponentCount() == 0) {
            this.maxWidth = 0;
            this.maxHeight = 0;
            this.rowsData = new ArrayList(0);
            return;
        }
        Insets insets = parent.getInsets();
        int parentWidth = parent.getWidth() - insets.left - insets.right;
        int currentRow = 0;
        int componentInRow = 0;
        this.maxWidth = 0;
        this.maxHeight = 0;
        int currentRowWidth = 0;
        int currentRowMaxHeight = 0;
        this.rowsData = new ArrayList();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component component = parent.getComponent(i);
            Dimension ps = component.getPreferredSize();
            if (componentInRow > 0 && (this.isWrapEachComponent() || currentRowWidth + this.hgap + ps.width > parentWidth)) {
                this.rowsData.get(currentRow).setWidth(currentRowWidth);
                this.rowsData.get(currentRow).setHeight(currentRowMaxHeight);
                this.maxWidth = Math.max(this.maxWidth, currentRowWidth);
                this.maxHeight += (currentRow > 0 ? this.vgap : 0) + currentRowMaxHeight;
                componentInRow = 0;
                currentRowWidth = 0;
                currentRowMaxHeight = 0;
                ++currentRow;
            }
            int componentWidth = this.fitWidth ? Math.min(ps.width, parentWidth) : ps.width;
            currentRowWidth += (componentInRow > 0 ? this.hgap : 0) + componentWidth;
            currentRowMaxHeight = Math.max(currentRowMaxHeight, ps.height);
            ++componentInRow;
            if (currentRow >= this.rowsData.size()) {
                this.rowsData.add(new RowData());
            }
            this.rowsData.get(currentRow).addComponent(component);
        }
        this.rowsData.get(currentRow).setWidth(currentRowWidth);
        this.rowsData.get(currentRow).setHeight(currentRowMaxHeight);
        this.maxHeight += (currentRow > 0 ? this.vgap : 0) + currentRowMaxHeight;
        this.maxHeight += insets.top + insets.bottom;
        int y = this.getStartY(parent, insets);
        for (RowData row : this.rowsData) {
            int x = this.getStartX(parent, insets, row);
            int i = 0;
            for (Component component : row.getComponents()) {
                int componentWidth;
                Dimension ps = component.getPreferredSize();
                int n = componentWidth = this.fitWidth ? Math.min(ps.width, parentWidth) : ps.width;
                if (this.fillWidth && i + 1 == row.getComponents().size() && this.halign == 2) {
                    componentWidth = insets.left + parentWidth - x;
                }
                component.setBounds(x, y, componentWidth, row.getHeight());
                x += componentWidth + this.hgap;
                ++i;
            }
            y += row.getHeight() + this.vgap;
        }
    }

    protected int getStartX(Container parent, Insets insets, RowData row) {
        int x = this.fillWidth || this.halign == 2 ? insets.left : (this.halign == 4 ? parent.getWidth() - insets.right - row.getWidth() : parent.getWidth() / 2 - row.getWidth() / 2);
        return x;
    }

    protected int getStartY(Container parent, Insets insets) {
        int y = this.valign == 1 ? insets.top : (this.valign == 3 ? parent.getHeight() - insets.bottom - this.maxHeight : insets.top + parent.getHeight() / 2 - this.maxHeight / 2);
        return y;
    }
}

