/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.WebLinkLabelStyle;
import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.HtmlUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WebUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;

public class WebLinkLabel
extends WebLabel {
    public static final ImageIcon LINK_ICON = new ImageIcon(WebLinkLabel.class.getResource("icons/link.png"));
    public static final ImageIcon EMAIL_ICON = new ImageIcon(WebLinkLabel.class.getResource("icons/email.png"));
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected List<ActionListener> actionListeners = new ArrayList<ActionListener>(1);
    protected boolean highlight = WebLinkLabelStyle.highlight;
    protected boolean onPressAction = WebLinkLabelStyle.onPressAction;
    protected boolean highlightVisited = WebLinkLabelStyle.highlightVisited;
    protected Color foreground = WebLinkLabelStyle.foreground;
    protected Color visitedForeground = WebLinkLabelStyle.visitedForeground;
    protected Runnable link = null;
    protected String actualText = "";
    protected boolean mouseover = false;
    protected boolean visitedOnce = false;

    public WebLinkLabel() {
        this.initializeSettings();
    }

    public WebLinkLabel(Icon image) {
        super(image);
        this.initializeSettings();
    }

    public WebLinkLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initializeSettings();
    }

    public WebLinkLabel(String text) {
        super(text);
        this.setText(text);
        this.initializeSettings();
    }

    public WebLinkLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment, new Object[0]);
        this.setText(text);
        this.initializeSettings();
    }

    public WebLinkLabel(String text, Icon icon) {
        super(text, icon);
        this.setText(text);
        this.initializeSettings();
    }

    public WebLinkLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment, new Object[0]);
        this.setText(text);
        this.initializeSettings();
    }

    protected void initializeSettings() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.updateForeground();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebLinkLabel.this.onPressAction) {
                    this.performAction(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!WebLinkLabel.this.onPressAction && SwingUtils.size(WebLinkLabel.this).contains(e.getPoint())) {
                    this.performAction(e);
                }
            }

            private void performAction(MouseEvent e) {
                if (WebLinkLabel.this.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                    WebLinkLabel.this.doClick();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WebLinkLabel.this.setMouseover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebLinkLabel.this.setMouseover(false);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                WebLinkLabel.this.setMouseover(false);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebLinkLabel.this.setMouseover(false);
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebLinkLabel.this.setMouseover(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                WebLinkLabel.this.setMouseover(false);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.ENTER.isTriggered(e) || Hotkey.SPACE.isTriggered(e)) {
                    WebLinkLabel.this.doClick();
                }
            }
        });
    }

    protected void setMouseover(boolean mouseover) {
        if (mouseover) {
            if (this.isEnabled() && this.highlight && !this.mouseover) {
                this.mouseover = true;
                this.updateText();
            }
        } else if (this.mouseover) {
            this.mouseover = false;
            this.updateText();
        }
    }

    public Color getUnvisitedForeground() {
        return this.foreground;
    }

    public void setUnvisitedForeground(Color foreground) {
        this.setForeground(foreground);
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.updateForeground();
    }

    public Color getVisitedForeground() {
        return this.visitedForeground;
    }

    public void setVisitedForeground(Color visitedForeground) {
        this.visitedForeground = visitedForeground;
        this.updateForeground();
    }

    protected void updateForeground() {
        WebLinkLabel.super.setForeground(this.highlightVisited && this.visitedOnce ? this.visitedForeground : this.foreground);
    }

    public String getActualText() {
        return this.actualText;
    }

    @Override
    public void setText(String text) {
        this.actualText = text;
        this.updateText();
    }

    protected void updateText() {
        if (this.mouseover && this.highlight) {
            if (!this.actualText.trim().equals("")) {
                String text = HtmlUtils.hasHtml(this.actualText) ? HtmlUtils.getContent(this.actualText) : this.actualText.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                WebLinkLabel.super.setText("<html><u>" + text + "</u></html>");
            } else {
                WebLinkLabel.super.setText("");
            }
        } else {
            WebLinkLabel.super.setText(this.actualText);
        }
    }

    public boolean isVisitedOnce() {
        return this.visitedOnce;
    }

    public Runnable getLink() {
        return this.link;
    }

    public void setLink(Runnable link) {
        this.link = link;
    }

    public void setLink(String text, Runnable link) {
        this.link = link;
        this.setText(text);
    }

    public void setLink(String address) {
        this.setLink(address, true);
    }

    public void setLink(String address, boolean setupView) {
        this.setLink(address, address, setupView);
    }

    public void setLink(String text, String address) {
        this.setLink(text, address, true);
    }

    public void setLink(String text, String address, boolean setupView) {
        this.setLink(text, this.createAddressLink(address), setupView);
    }

    public void setLink(String text, Runnable link, boolean setupView) {
        if (setupView) {
            this.setIcon(LINK_ICON);
            this.setText(text);
        }
        this.link = link;
    }

    public void setEmailLink(String email) {
        this.setEmailLink(email, true);
    }

    public void setEmailLink(String email, boolean setupView) {
        this.setEmailLink(email, email, setupView);
    }

    public void setEmailLink(String text, String email) {
        this.setEmailLink(text, email, true);
    }

    public void setEmailLink(String text, String email, boolean setupView) {
        if (setupView) {
            this.setIcon(EMAIL_ICON);
            this.setText(text);
        }
        this.link = this.createEmailLink(email);
    }

    public void setFileLink(File file) {
        this.setFileLink(file, true);
    }

    public void setFileLink(File file, boolean setupView) {
        this.setFileLink(FileUtils.getDisplayFileName(file), file, setupView);
    }

    public void setFileLink(String text, File file) {
        this.setFileLink(text, file, true);
    }

    public void setFileLink(String text, File file, boolean setupView) {
        if (setupView) {
            this.setIcon(FileUtils.getFileIcon(file));
            this.setText(text);
        }
        this.link = this.createFileLink(file);
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.updateText();
    }

    public boolean isHighlightVisited() {
        return this.highlightVisited;
    }

    public void setHighlightVisited(boolean highlightVisited) {
        this.highlightVisited = highlightVisited;
        this.updateForeground();
    }

    public boolean isOnPressAction() {
        return this.onPressAction;
    }

    public void setOnPressAction(boolean onPressAction) {
        this.onPressAction = onPressAction;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void doClick() {
        this.visitedOnce = true;
        this.updateForeground();
        if (this.link != null) {
            this.link.run();
        }
        this.fireActionPerformed();
    }

    protected void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, 0, "Link opened");
        for (ActionListener actionListener : CollectionUtils.copy(this.actionListeners)) {
            actionListener.actionPerformed(event);
        }
    }

    protected Runnable createAddressLink(final String address) {
        if (address != null) {
            return new Runnable(){

                @Override
                public void run() {
                    WebLinkLabel.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            WebUtils.browseSiteSafely(address);
                        }
                    });
                }
            };
        }
        return null;
    }

    protected Runnable createEmailLink(final String email) {
        if (email != null) {
            return new Runnable(){

                @Override
                public void run() {
                    WebLinkLabel.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            WebUtils.writeEmailSafely(email);
                        }
                    });
                }
            };
        }
        return null;
    }

    protected Runnable createFileLink(final File file) {
        if (file != null) {
            return new Runnable(){

                @Override
                public void run() {
                    WebLinkLabel.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            WebUtils.openFileSafely(file);
                        }
                    });
                }
            };
        }
        return null;
    }
}

