/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.CustomStyle;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyleRangeComparator;
import com.alee.extended.label.TextRange;
import com.alee.extended.label.WebStyledLabel;
import com.alee.utils.xml.ColorConverter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.View;

public final class StyledLabelUtils
implements SwingConstants {
    private static final Comparator<StyleRange> styleRangeComparator = new StyleRangeComparator();

    public static void buildTextRanges(WebStyledLabel label, List<TextRange> textRanges) {
        textRanges.clear();
        List<StyleRange> styleRanges = label.getStyleRanges();
        Collections.sort(styleRanges, styleRangeComparator);
        String s = label.getText();
        if (s != null && s.length() > 0) {
            int index = 0;
            for (StyleRange styleRange : styleRanges) {
                String text;
                if (index >= s.length()) break;
                if (styleRange.getStartIndex() > index) {
                    text = s.substring(index, Math.min(styleRange.getStartIndex(), s.length()));
                    StyleRange newRange = new StyleRange(index, styleRange.getStartIndex() - index, new CustomStyle[0]);
                    StyledLabelUtils.addStyledTexts(text, newRange, textRanges);
                    index = styleRange.getStartIndex();
                }
                if (styleRange.getStartIndex() != index) continue;
                if (styleRange.getLength() == -1) {
                    text = s.substring(index);
                    StyledLabelUtils.addStyledTexts(text, styleRange, textRanges);
                    index = s.length();
                    continue;
                }
                text = s.substring(index, Math.min(index + styleRange.getLength(), s.length()));
                StyledLabelUtils.addStyledTexts(text, styleRange, textRanges);
                index += styleRange.getLength();
            }
            if (index < s.length()) {
                String text = s.substring(index, s.length());
                StyleRange range = new StyleRange(index, s.length() - index, new CustomStyle[0]);
                StyledLabelUtils.addStyledTexts(text, range, textRanges);
            }
        }
    }

    private static void addStyledTexts(String text, StyleRange range, List<TextRange> textRanges) {
        range = new StyleRange(range);
        int index1 = text.indexOf(13);
        int index2 = text.indexOf(10);
        while (index1 >= 0 || index2 >= 0) {
            int index;
            int n = index = index1 >= 0 ? index1 : -1;
            if (index2 >= 0 && (index2 < index1 || index < 0)) {
                index = index2;
            }
            String subString = text.substring(0, index);
            StyleRange newRange = new StyleRange(range);
            newRange.setStartIndex(range.getStartIndex());
            newRange.setLength(index);
            textRanges.add(new TextRange(subString, newRange));
            int length = 1;
            if (text.charAt(index) == '\r' && index + 1 < text.length() && text.charAt(index + 1) == '\n') {
                ++length;
            }
            newRange = new StyleRange(range);
            newRange.setStartIndex(range.getStartIndex() + index);
            newRange.setLength(length);
            textRanges.add(new TextRange(text.substring(index, index + length), newRange));
            text = text.substring(index + length);
            range.setStartIndex(range.getStartIndex() + index + length);
            range.setLength(range.getLength() - index - length);
            index1 = text.indexOf(13);
            index2 = text.indexOf(10);
        }
        if (text.length() > 0) {
            textRanges.add(new TextRange(text, range));
        }
    }

    public static Font getFont(WebStyledLabel label) {
        Font font = label.getFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public static int findNextWordStartIndex(String string, int firstRowEndIndex) {
        boolean skipFirstWord = firstRowEndIndex < 0;
        for (int i = firstRowEndIndex + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                if (skipFirstWord) continue;
                return i;
            }
            skipFirstWord = false;
        }
        return string.length();
    }

    public static int findFirstRowWordEndIndex(String string) {
        boolean spaceFound = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (!spaceFound) {
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
                spaceFound = true;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return i;
        }
        return -1;
    }

    public static String layoutCompoundLabel(WebStyledLabel label, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (label != null && !label.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return StyledLabelUtils.layoutCompoundLabelImpl(label, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return StyledLabelUtils.layoutCompoundLabelImpl(null, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(WebStyledLabel label, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        boolean lsb = false;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            View v;
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = label != null ? (View)label.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        int maxIconY = viewR.height / 2;
        Insets insets = label.getInsets();
        int leftMostX = viewR.x;
        int rightMostX = viewR.width;
        rightMostX -= iconR.width;
        if (horizontalTextPosition == 0) {
            iconR.x = viewR.width < textR.width ? (leftMostX + rightMostX) / 2 : textR.x + (textR.width - iconR.width) / 2;
        } else if (iconR.x < leftMostX) {
            textR.x += leftMostX - iconR.x;
            iconR.x = leftMostX;
        } else if (iconR.x > rightMostX && horizontalAlignment != 2) {
            iconR.x = rightMostX;
            textR.x -= iconR.x - rightMostX;
        }
        if (insets != null) {
            maxIconY -= (insets.bottom + insets.top) / 2;
        }
        if (icon != null) {
            maxIconY -= icon.getIconHeight() / 2;
        }
        if (verticalAlignment == 1) {
            iconR.y = Math.min(maxIconY, iconR.y);
        } else if (verticalAlignment == 3) {
            iconR.y = Math.max(maxIconY, iconR.y);
        }
        return text;
    }

    public static String getPlainText(String text, List<StyleRange> styles) {
        String plainText = "";
        String trimmedText = text;
        int begin = StyledLabelUtils.nextUnescaped(trimmedText, "{", 0);
        if (begin != -1) {
            while (begin != -1) {
                int end = StyledLabelUtils.nextUnescaped(trimmedText, "}", begin + 1);
                if (end != -1) {
                    TextRange range = StyledLabelUtils.parseStatement(trimmedText.substring(begin + 1, end));
                    if (range != null) {
                        plainText = plainText + trimmedText.substring(0, begin);
                        range.getStyleRange().setStartIndex(plainText.length());
                        styles.add(range.getStyleRange());
                        plainText = plainText + range.getText();
                    } else {
                        plainText = plainText + trimmedText;
                    }
                    trimmedText = trimmedText.substring(end + 1);
                    begin = StyledLabelUtils.nextUnescaped(trimmedText, "{", 0);
                    continue;
                }
                plainText = plainText + trimmedText;
            }
            plainText = plainText + trimmedText;
        } else {
            plainText = text;
        }
        return plainText;
    }

    private static int nextUnescaped(String trimmedText, String pattern, int from) {
        return trimmedText.indexOf(pattern, from);
    }

    private static TextRange parseStatement(String statement) {
        int sep = statement.indexOf(":");
        if (sep != -1) {
            try {
                String text = statement.substring(0, sep);
                boolean p = false;
                boolean b = false;
                boolean i = false;
                Color fg = null;
                Color bg = null;
                ArrayList<CustomStyle> customStyles = new ArrayList<CustomStyle>();
                String vars = statement.substring(sep + 1);
                StringTokenizer st = new StringTokenizer(vars, ";", false);
                while (st.hasMoreTokens()) {
                    Color color;
                    String token = st.nextToken();
                    if (token.equals("p") || token.equals("plain")) {
                        p = true;
                        continue;
                    }
                    if (token.equals("b") || token.equals("bold")) {
                        b = true;
                        continue;
                    }
                    if (token.equals("i") || token.equals("italic")) {
                        i = true;
                        continue;
                    }
                    if (token.equals("u") || token.equals("underlined")) {
                        customStyles.add(CustomStyle.underlined);
                        continue;
                    }
                    if (token.equals("sp") || token.equals("sup") || token.equals("superscript")) {
                        customStyles.add(CustomStyle.superscript);
                        continue;
                    }
                    if (token.equals("sb") || token.equals("sub") || token.equals("subscript")) {
                        customStyles.add(CustomStyle.subscript);
                        continue;
                    }
                    if (token.equals("s") || token.equals("strike")) {
                        customStyles.add(CustomStyle.strikeThrough);
                        continue;
                    }
                    if (token.equals("ds") || token.equals("doublestrike")) {
                        customStyles.add(CustomStyle.doubleStrikeThrough);
                        continue;
                    }
                    if (token.startsWith("c") || token.startsWith("color") || token.startsWith("f") || token.startsWith("foreground")) {
                        color = StyledLabelUtils.parseColor(token);
                        if (color == null) continue;
                        fg = color;
                        continue;
                    }
                    if (!token.startsWith("b") && !token.startsWith("background") || (color = StyledLabelUtils.parseColor(token)) == null) continue;
                    bg = color;
                }
                int style = b && i ? 3 : (b ? 1 : (i ? 2 : (p ? 0 : -1)));
                CustomStyle[] cs = customStyles.toArray(new CustomStyle[customStyles.size()]);
                return new TextRange(text, new StyleRange(0, text.length(), style, fg, bg, cs));
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    private static Color parseColor(String statement) {
        int i1 = statement.indexOf("(");
        int i2 = statement.lastIndexOf(")");
        if (i1 != -1 && i2 != -1) {
            try {
                String colorString = statement.substring(i1 + 1, i2);
                return ColorConverter.parseColor(colorString);
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }
}

