/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.drag;

import com.alee.utils.DragUtils;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.TransferHandler;

public class ImageDropHandler
extends TransferHandler {
    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return this.isDropEnabled();
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        return info.isDrop() && this.importData(info.getTransferable());
    }

    public boolean importData(Transferable t) {
        if (this.isDropEnabled()) {
            Image image;
            ArrayList<ImageIcon> images = new ArrayList<ImageIcon>();
            List<File> files = DragUtils.getImportedFiles(t);
            if (files != null) {
                for (File file : files) {
                    images.add(new ImageIcon(file.getAbsolutePath()));
                }
            }
            if ((image = DragUtils.getImportedImage(t)) != null) {
                images.add(new ImageIcon(image));
            }
            return this.isDropEnabled() && this.imagesImported(images);
        }
        return false;
    }

    protected boolean isDropEnabled() {
        return true;
    }

    protected boolean imagesImported(List<ImageIcon> images) {
        return true;
    }
}

