/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;
import java.util.WeakHashMap;

public class WebSwitchLayout
extends AbstractLayoutManager {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String GRIPPER = "GRIPPER";
    private Map<Component, String> constraints = new WeakHashMap<Component, String>();
    private float gripperLocation = 0.0f;

    public float getGripperLocation() {
        return this.gripperLocation;
    }

    public void setGripperLocation(float gripperLocation) {
        this.gripperLocation = gripperLocation;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        String value = (String)constraints;
        if (value == null || !value.equals(LEFT) && !value.equals(RIGHT) && !value.equals(GRIPPER)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'LEFT'/'RIGHT'/'GRIPPER' string");
        }
        this.constraints.put(component, value);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (Map.Entry<Component, String> constraint : this.constraints.entrySet()) {
            Dimension ps = constraint.getKey().getPreferredSize();
            maxWidth = Math.max(ps.width, maxWidth);
            maxHeight = Math.max(ps.height, maxHeight);
        }
        Insets insets = parent.getInsets();
        return new Dimension(insets.left + maxWidth * 2 + insets.right, insets.top + maxHeight + insets.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right;
        int partWidth = width / 2;
        int height = parent.getHeight() - insets.top - insets.bottom;
        int leftX = insets.left;
        int rightX = leftX + width / 2;
        int y = insets.top;
        for (Map.Entry<Component, String> entry : this.constraints.entrySet()) {
            String constraint = entry.getValue();
            if (constraint.equals(GRIPPER)) {
                int x = ltr ? leftX + Math.round(this.gripperLocation * (float)partWidth) : rightX - Math.round(this.gripperLocation * (float)partWidth);
                entry.getKey().setBounds(x, y, partWidth, height);
                continue;
            }
            if (ltr && constraint.equals(LEFT) || !ltr && constraint.equals(RIGHT)) {
                entry.getKey().setBounds(leftX, y, partWidth, height);
                continue;
            }
            if ((!ltr || !constraint.equals(RIGHT)) && (ltr || !constraint.equals(LEFT))) continue;
            entry.getKey().setBounds(rightX, y, partWidth, height);
        }
    }
}

