## iOS Development

## Introduction
- [Introduction to iOS](https://developer.apple.com/tutorials/app-dev-training)
- [Xcode Setup](https://www.youtube.com/watch?v=vKPCvAPW9Ns)

## Introduction To Swift
- [Swift Book](https://docs.swift.org/swift-book/LanguageGuide/TheBasics.html)
- [Swift Course](https://www.youtube.com/watch?v=FcsY1YPBwzQ)

## iOS Development Course
#### SwiftUI (Recommend First):
- [Introduction to SwiftUI](https://developer.apple.com/tutorials/swiftui)
- [100 Days Of SwiftUI](https://www.hackingwithswift.com/100/swiftui)
- [Hacking with SwiftUI](https://www.hackingwithswift.com/books/ios-swiftui)

#### UIKit:
- [100 Days Of Swift](https://www.hackingwithswift.com/100)
- [Hacking with Swift](https://www.hackingwithswift.com/read)

## View Navigation
- [SwiftUI Navigation](https://www.kodeco.com/5824937-swiftui-tutorial-navigation)
- [UIKit Navigation](https://www.youtube.com/watch?v=LbAd2FIlnos)

## Networking
- [Netowking in SwiftUI](https://medium.com/@nutanbhogendrasharma/consume-rest-api-in-swiftui-ios-mobile-app-b3c5d6ecf401)
- [Netowking in UIKit](https://www.freecodecamp.org/news/how-to-make-your-first-api-call-in-swift/)
- [Post API Call](https://www.youtube.com/watch?v=o3Rkg6WmZoY)
- [Advance Networking](https://malcolmkmd.medium.com/writing-network-layer-in-swift-protocol-oriented-approach-4fa40ef1f908)

## JSON Parsing
- [JSON Decoder](https://www.avanderlee.com/swift/json-parsing-decoding/)
- [JSON Serialization](https://www.hackingwithswift.com/example-code/system/how-to-parse-json-using-jsonserialization)

## Database
- [Core Data Basics](https://medium.com/@ankurvekariya/core-data-crud-with-swift-4-2-for-beginners-40efe4e7d1cc)
- [Core Data](https://youtube.com/playlist?list=PLMRqhzcHGw1aDYKmCuqXQ_IqpWpJlpoJ3)
- [Realm](https://www.kodeco.com/32960966-realm-with-swiftui-tutorial-getting-started)
- [Firebase](https://www.kodeco.com/11609977-getting-started-with-cloud-firestore-and-swiftui)
- [Firebase Project](https://youtube.com/playlist?list=PL0dzCUj1L5JEN2aWYFCpqfTBeVHcGZjGw)

## Dependancy Manager
- [Swift Package Manager](https://cocoacasts.com/xcode-fundamentals-how-to-add-a-swift-package-to-a-project)
- [Cocoapods](https://codewithchris.com/cocoapods/)

## Concurrency
- [Basic's Concepts](https://betterprogramming.pub/concurrency-in-ios-and-swift-guide-50443ce5b0f5)
- [Concurrency in Depth](https://www.freecodecamp.org/news/ios-concurrency/)
- [Async/Await](https://www.avanderlee.com/swift/async-await/)

## Architectures & Design Patterns
- [MVVM Architecture in UIKit](https://www.youtube.com/watch?v=iI0LabCYZJo)
- [MVVM Architecture in SwiftUI](https://azamsharp.medium.com/mvvm-in-swiftui-8a2e9cc2964a)
- [MVP Architecture in UIKit](https://www.youtube.com/watch?v=SFqIP5jYn_4)
- [VIPER Architecture in UIKit](https://www.youtube.com/watch?v=hFLdbWEE3_Y)
- [SOLID Principals](https://betterprogramming.pub/swift-s-o-l-i-d-21203ba3a226)
- [Design Patterns](https://aglowiditsolutions.com/blog/top-swift-design-patterns/)

## Most Useful Tools
- [Xcode Tools & Tricks](https://www.youtube.com/watch?v=ZAqnJQn7xp4): Learn Xocde most essential tools for iOS development.
- [SourceTree](https://www.sourcetreeapp.com): A Git GUI that offers a visual representation of your repositories. Sourcetree is a free Git client for Windows and Mac.
- [QuickType.io](https://app.quicktype.io): Convert JSON data into Swift model.
- [Diawi](https://www.diawi.com): Deploy and test application directly to the devices.
- [App icon Generator](https://appicon.co): Generate app icons for different devices.
- [Device Shots](https://deviceshots.com): Design device mockups with the screenshot of your website or mobile application.
- [Transporter](https://apps.apple.com/us/app/transporter/id1450874784?mt=12): Deplay your iOS applications super fast.

## Practice Projects
- [Liquid Coder](https://liquidcoder.com/courses): Amazing SwiftUI projects for beginners.
- [Kevsoft](https://www.youtube.com/c/Kavsoft/videos): Design complex and beautiful UI in SwiftUI.
- [Spotify Clone](https://youtube.com/playlist?list=PL5PR3UyfTWve9ZC7Yws0x6EGjBO2FGr0o): Complete step by step process to build spotify clone in UIKit.

## Most Useful Links
- [Apple Developer Videos](https://developer.apple.com/videos/topics/): Why this link is in the last? because it requires basic knowledge of iOS development.
- [Advance SwiftUI Animation](https://swiftui-lab.com): Contains detailed knowledge of animations that might not be found in the documentation.
